/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.galerie;

import java.io.Writer;

import com.univ.mediatheque.player.MediaPlayer;
import com.univ.mediatheque.playlist.MediaPlaylist;
import com.univ.mediatheque.playlist.visionneuse.VisionneusePlaylist;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;

/**
 * Une galerie multimedia est un élément qui permet d'afficher des {@link Media} à l'écran en s'abstrayant du type de ces médias. Avec cet élément on s'interesse qu'à la
 * présentation générale (c'est un élément de contenu) et l'arangement des {@link Media} sur une page HTML.<br/>
 * Pour atteindre un niveau d'abstraction adéquat on à utiliser divers notion comme les {@link VisionneuseMedia}, les {@link MediaPlayer}, les {@link PlayerStyleStyle} et les
 * {@link PlaylistStyle}.
 * 
 * @author Pierre Cosson
 */
public interface Galerie {

	GalerieType getType();

	String getName();

	void setTitre(String titre);

	void setVisionneusePlaylist(VisionneusePlaylist visionneusePlaylist);

	void afficherGalerieComplete(ContexteUniv ctx, Writer out, MediaPlaylist mediaList) throws Exception;

	void initialiserPlayer(ContexteUniv ctx, Writer out, MediaPlaylist mediaList) throws Exception;

	void initialiserPlaylist(ContexteUniv ctx, Writer out, MediaPlaylist mediaList) throws Exception;
}
