/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.player;

import com.univ.mediatheque.container.LanceurMedia;
import com.univ.mediatheque.style.PlayerStyle;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;

/**
 * Un {@link MediaPlayer} permet de construire le code HTML capable d'utiliser un élément permettant de jouer un média.
 * 
 * Un player est un ensemble de ligne de code pouvant comprende du JS, de l'HTML et/ou du flash (la majeur partie du temps c'est les 3).
 * 
 * @author Pierre Cosson
 */
public interface MediaPlayer {

	/**
	 * Récupérer le type de Player dont il s'agit.
	 * 
	 * @return Le type de player
	 */
	MediaPlayerType getType();

	/**
	 * Récupérer le code HTML permettant d'nitialiser le player de média.
	 * 
	 * @param ctx
	 *            Le contexte de l'application.
	 * 
	 * @param playerId
	 * @return le code HTML qui permet d'initialiser le player coté client.
	 */
	String getInialiserVuePlayer(ContexteUniv ctx, String playerId);

	/**
	 * L'URL du player distant (utilisé dans le mode popup, il s'agit d'une page JSP qu'il est possible d'appeler via une requête AJAX).
	 * 
	 * @param ctx
	 * @param media
	 *            le MEDIA à jouer
	 * @return L'URL du player distant.
	 */
	String getURLPlayerDistant(ContexteUniv ctx, Media media);

	/**
	 * Récupérer l'élément ou les éléments (HTML ou JS) capable de faire jouer le média dans le player.
	 * 
	 * @param ctx
	 *            Le contexte de l'application pour l'accés à la base de données.
	 * @param media
	 *            Le média.
	 * @param playerId
	 *            L'Identifiant du player dans la galerie.
	 * @return Le {@link LanceurMedia} qui peut lancer le média dans le player.
	 */
	LanceurMedia getLanceurMedia(ContexteUniv ctx, Media media, String playerId);

	/**
	 * Récupérer le {@link PlayerStyle} d'affichage du player instancier.
	 * 
	 * @return le style du player ou NULL si ce dernier n'en posséde pas.
	 */
	PlayerStyle getStyle();
}
