/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.player.visionneuse;

import java.io.Writer;

import com.univ.mediatheque.player.MediaPlayer;
import com.univ.mediatheque.style.MediaStyle;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;

/**
 * Element qui permet de produire du code HTML afin d'afficher un certain type de média.
 * 
 * @author Pierre Cosson
 */
public interface VisionneusePlayer {

	/**
	 * Savoir dans quel mode va se faire l'affichage du player.
	 * 
	 * @return Le type d'affichage de la visionneuse.
	 */
	VisionneusePlayerType getType();

	void initialiserVisionneuse(ContexteUniv ctx, Writer out, MediaPlayer player) throws Exception;

	/**
	 * Initialise le style de média : {@link MediaStyle} en lui affectant le lanceur.
	 * 
	 * @param ctx
	 * @param media
	 * @param player
	 * @param mediaStyle
	 */
	void setLanceurMedia(ContexteUniv ctx, Media media, MediaPlayer player, MediaStyle mediaStyle);

	void init();

	int getMaxHeight();

	int getMaxWidth();
}
