/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.playlist;

import java.util.List;

import com.univ.mediatheque.player.MediaPlayer;
import com.univ.mediatheque.player.visionneuse.VisionneusePlayer;
import com.univ.mediatheque.style.MediaStyle;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;

public interface MediaPlaylist {

	/**
	 * Récupérer le nom de la playlist.
	 * 
	 * @return le nom de la playlist.
	 */
	String getName();

	/**
	 * Définir le contexte de l'application dans la playlist.
	 * 
	 * @param ctx
	 */
	void setCtx(ContexteUniv ctx);

	/**
	 * Définir le titre de la playlist qui sera affichée en fonction mode d'affichage choisi.
	 * 
	 * @param titre
	 *            Le titre de la playlist.
	 */
	void setTitre(String titre);

	/**
	 * Récupérer le titre de la playlist.
	 * 
	 * @return le titre de la playlist.
	 */
	String getTitre();

	/**
	 * Récupérer la liste de média associée à cette playlist.
	 * 
	 * @return La liste de média.
	 * 
	 */
	List<Media> getMediaList();

	void setMediaList(List<Media> medias);

	/**
	 * Récupérer le style associé au média
	 * 
	 * @param media
	 *            Le média.
	 * @return Le style du média.
	 */
	MediaStyle getMediaStyle(Media media);

	/**
	 * Récupérer le player en fonction du média.
	 * 
	 * @param media
	 *            Le média à jouer.
	 * @return le player capable de jouer le média.
	 */
	MediaPlayer getMediaPlayer(Media media);

	/**
	 * Récupérer la visionneuse de player de média en fonction du média à afficher.
	 * 
	 * @param media
	 *            Le média qui sera affiché par le player
	 * @return La visionneuse de player.
	 */
	VisionneusePlayer getVisionneusePlayer(Media media);

	/**
	 * Initialiser la playlist.s
	 */
	void init();
}
