/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.playlist.visionneuse;

import com.univ.mediatheque.player.visionneuse.VisionneusePlayerType;

/**
 * Présente l'ensemble des visionneuses de
 * 
 * @author Pierre
 * 
 */
public enum VisionneusePlaylistType {
	/**
	 * Affichage de la playlist sous forme de page
	 */
	PAGINATION("pagination"),
	/**
	 * Affichage de la playlist sour forme d'une liste UL-LI.
	 */
	DEFAUT("defaut");

	private String libelle;

	/**
	 * Constructeur.
	 * 
	 * @param libelle
	 *            Le libellé de l'enumération.
	 */
	private VisionneusePlaylistType(String libelle) {
		this.libelle = libelle;
	}

	/**
	 * Tester un ENUM avec un libellé. C'est le libellé de l'ENUM qui est testé (le test est non case sensitive).
	 * 
	 * @param libelle
	 *            Le libellé de test.
	 * @return TRUE si le libellé et l'ENUM sont similaire sinon FALSE.
	 */
	public boolean isSameLibelle(String libelle) {
		return this.libelle.equalsIgnoreCase(libelle);
	}

	/**
	 * Récupérer un ENUM en fonction du libellé
	 * 
	 * @param libelle
	 *            Le libellé du {@link VisionneusePlayerType} à récupérer.
	 * @return {@link VisionneusePlayerType} correspondant au libellé s'il existe sinon NULL.
	 */
	public static VisionneusePlaylistType getVisionneuseModeAffichage(String libelle) {
		int i;
		VisionneusePlaylistType[] values = VisionneusePlaylistType.values();
		for (i = 0; i < values.length; i++) {
			if (values[i].isSameLibelle(libelle)) {
				break;
			}
		}
		if (i >= values.length) {
			return null;
		} else {
			return values[i];
		}
	}
}
