/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.scheduler;

import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.core.config.PropertyHelper;
import com.kportal.scheduling.spring.quartz.LogReportJob;
import com.univ.mediatheque.utils.MediathequeHelper;
import com.univ.objetspartages.om.Media;
import com.univ.utils.FileUtil;
import com.univ.utils.ImageInfo;
import com.univ.utils.PhotoUtil;

import java.io.File;
import java.io.FileInputStream;

public class GenerateThumbnailJob extends LogReportJob {

	@Override
	public void perform() {
		String[] thumbnailDimensions = PropertyHelper.getCoreProperty(MediathequeHelper.CRITERES_VIGNETTE_PROPERTIES_KEY).split("/", -2);
		int width = Integer.parseInt(thumbnailDimensions[1]);
		int height = Integer.parseInt(thumbnailDimensions[2]);
		rebuildThumbnails(width, height);
	}

	public void rebuildThumbnails(int requestedWidth, int requestedHeight) {
		ContextePage ctx = null;
		boolean resize = true;
		try {
			ctx = new ContextePage();
			Media media = new Media();
			media.setCtx(ctx);
			media.init();
			logger.info(String.format("%d médias à traiter", media.count(" where T1.TYPE_RESSOURCE = 'photo'")));
			media.select(" where T1.TYPE_RESSOURCE = 'photo'");
			while (media.nextItem()) {
				try {
					logger.info(String.format("Traitement du média \"%s\"", media.getUrlAbsolue()));
					resize = true;
					String vignetteDestinationPath = "";
					if (media.getUrlVignette().length() == 0) {
						resize = false;
						logger.info(String.format("Pas de vignette pour le média \"%s\". Passage au média suivant.", media.getUrlAbsolue()));
					} else {
						logger.info(String.format("Vignette détectée pour le média \"%s\". Récupération des informations.", media.getUrlAbsolue()));
						vignetteDestinationPath = media.getPathAbsolu().replaceFirst("[^/\\\\]*$", media.getUrlVignette());
						File vignetteDestination = new File(vignetteDestinationPath);
						if (vignetteDestination.exists() && vignetteDestination.isFile()) {
							// recuperation des informations de la vignette
							FileInputStream fis = null;
							ImageInfo ii = new ImageInfo();
							try {
								fis = new FileInputStream(vignetteDestinationPath);
								ii.setInput(fis);
								ii.check();
								ii.close();
							} finally {
								if (fis != null) {
									fis.close();
									ii.close();
								}
							}
						}
					}
					if (resize) {
						logger.info(String.format("Création de la vignette pour le média \"%s\".", media.getUrlAbsolue()));
						// pas de données enregistrées : on essaye de calculer les dimensions de l'image
						// à partir du fichier physique
						FileInputStream mediaFileIs = null;
						File mediaFile = null;
						ImageInfo imageInfo = new ImageInfo();
						try {
							logger.info(String.format("Tentative de calcul des dimensions du média %s", media.getUrlAbsolue()));
							mediaFile = new File(media.getPathAbsolu());
							//uniquement si fichier source existe
							if (mediaFile.exists()) {
								mediaFileIs = new FileInputStream(mediaFile);
								imageInfo.setInput(mediaFileIs);
							} else {
								continue;
							}
						} catch (Exception e) {
							logger.error(String.format("Echec lors de la tentative de calcul des dimensions du média %s", media.getUrlAbsolue()), e);
						} finally {
							if (mediaFileIs != null) {
								mediaFileIs.close();
								imageInfo.close();
							}
						}
						int largeurVignette = requestedWidth;
						int hauteurVignette = requestedHeight;
						logger.info(String.format("Préparation du redimmensionnement du média %s : dimension ciblée [%dx%d]", media.getUrlAbsolue(), largeurVignette,
							hauteurVignette));
						// création de la vignette
						mediaFile = new File(media.getPathAbsolu());
						//uniquement si fichier source existe
						if (mediaFile.exists()) {
							File vignette = PhotoUtil.resize(media.getPathAbsolu(), FileUtil.getExtension(media.getUrl()), largeurVignette, hauteurVignette, false);
							FileUtil.copierFichier(vignette, new File(vignetteDestinationPath), vignette.getName().startsWith("tmp_"));
						} else {
							logger.info(String.format("Média %s inexistant. Passage au média suivant.", media.getUrlAbsolue()));
							continue;
						}
					}
				} catch (Exception e) {
					logger.error(String.format("Une erreur est survenue lors de la tentative de génération de vignette pour le média %s", media.getUrlAbsolue()), e);
				}
			}
		} catch (Exception e) {} finally {
			if (ctx != null) {
				ctx.release();
			}
		}
	}
}
