/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.style;

import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.lang3.StringUtils;

/**
 * This class is a key type media mapper that maps a key used in back office with a key used in front office. The map is a TreeMap and contains those values :
 * 
 * ("photo", "image") ("fichier", "doc") ("audio", "audio") ("video", "undefined") ("flash", "flash")
 * 
 * Note that "video" is mapped to "undefined" letting the front library calculate the type to determine if it should used a local player or just load the target video in is site's
 * player (e.g. Youtube videos).
 * 
 * 
 * @author alexandre.baillif
 * 
 */
public final class MapMedia {

	private final static String UNDEFINED = "undefined";

	private final Map<String, String> correspondanceMedia = new TreeMap<String, String>();

	private static MapMedia instance = new MapMedia();

	public static MapMedia getInstance() {
		return instance;
	}

	private MapMedia() {
		correspondanceMedia.put("photo", "image");
		correspondanceMedia.put("fichier", "doc");
		correspondanceMedia.put("audio", "audio");
		correspondanceMedia.put("video", UNDEFINED); //Special case, cf. Javadoc
		correspondanceMedia.put("flash", "flash");
	}

	/**
	 * Return the type of a media, making a corresponding between the back office key types and the front office key types.
	 * 
	 * @return
	 */
	public String getTypeMediaFront(final String backOfficeKey) {
		String result = correspondanceMedia.get(backOfficeKey);
		if (StringUtils.isBlank(result)) {
			result = UNDEFINED;
		}
		return result;
	}
}
