/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.style;

import com.univ.mediatheque.container.LanceurMedia;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;

/**
 * Style d'affichage d'un média. Cette interface est à implémenter pour afficher changer l'affichage d'un média dans la playlist d'une galerie.
 * 
 * @author pierre.cosson
 * 
 */
public interface MediaStyle {

	/**
	 * Récupérer le nom du style (est utilisé comme classe CSS)
	 * 
	 * @return le nom du style.
	 */
	String getName();

	void setCtx(ContexteUniv ctx);

	/**
	 * Injecter dans le style d'affichage le lanceur de média.
	 * 
	 * @param lanceur
	 *            Le lanceur de média.
	 */
	void setLanceurMedia(LanceurMedia lanceur);

	/**
	 * Cette fonction permet de génerer pour un média donné son affichage dans une playlist.
	 * 
	 * @param media
	 *            Le média à a
	 * @return
	 */
	String getContenuHTML(Media media);

	void init();
}
