/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.style;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.univ.mediatheque.Mediatheque;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.SpecificMedia;
import com.univ.utils.URLResolver;

public class MediaStyleSimple extends AbstractMediaStyle {

	/**
	 * Hauteur max de la vignette par défaut.
	 */
	protected int HAUTEUR_MAX_VIGNETTE_DEFAUT = 75;

	/**
	 * Largeur max de la vignette par défaut
	 */
	protected int LARGEUR_MAX_VIGNETTE_DEFAUT = 100;

	private static final Logger LOG = LoggerFactory.getLogger(MediaStyleSimple.class);

	private String messageInformatifLanceur;

	private int hauteurMaxVignette = HAUTEUR_MAX_VIGNETTE_DEFAUT;

	private int largeurMaxVignette = LARGEUR_MAX_VIGNETTE_DEFAUT;

	public void setMessageInformatifLanceur(final String messageInformatifLanceur) {
		this.messageInformatifLanceur = messageInformatifLanceur;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.univ.mediatheque.style.AbstractMediaStyle#getHTML(com.univ.objetspartages
	 * .om.Media)
	 */
	@Override
	protected String getHTML(final Media media) {
		final StringBuilder returnString = new StringBuilder();
		final String legende = media.getLegende();
		returnString.append("<div class=\"style1_media\">");
		final Properties proprieteMedia = new Properties();
		try {
			proprieteMedia.load(new ByteArrayInputStream(media.getSpecificData().getBytes()));
		} catch (final IOException e) {
			LOG.error(e.getMessage(), e);
		}
		returnString.append(this.genererLanceurMediaDebut(media));
		returnString.append("<span class=\"style1_media_vignette\" style=\"height:");
		returnString.append(String.valueOf(this.getHauteurMaxVignette()));
		returnString.append("px; line-height:");
		returnString.append(String.valueOf(this.getHauteurMaxVignette()));
		returnString.append("px\"><img src=\"");
		if (media.getUrlVignetteAbsolue().length() > 0) {
			returnString.append(URLResolver.getAbsoluteUrl(media.getUrlVignetteAbsolue(), this.ctx));
		} else {
			final Mediatheque mediatheque = Mediatheque.getInstance();
			final SpecificMedia specificMedia = mediatheque.getRessource(media.getTypeRessource());
			returnString.append(URLResolver.getAbsoluteUrl(specificMedia.getUrlVignette(), this.ctx));
		}
		returnString.append("\"");
		returnString.append(" alt=\"");
		returnString.append(StringEscapeUtils.escapeHtml4(legende));
		returnString.append("\" />");
		returnString.append("<span class=\"style1_media_contenu\">");
		String titre = media.getTitre();
		if (StringUtils.isEmpty(titre)) {
			titre = media.getSource();
		}
		returnString.append("<strong class=\"style1_media_titre\">");
		returnString.append("<p class=\"titre_corps\">");
		returnString.append(titre);
		returnString.append("</p>");
		if (StringUtils.isNotEmpty(legende)) {
			returnString.append("<p class=\"style1_media_legende\">");
			returnString.append(legende);
			returnString.append("</p>");
		}
		returnString.append("</strong>");
		returnString.append("</span><!-- style1_media_contenu -->");
		returnString.append("</span>");
		returnString.append(this.genererLanceurMediaFin(media));
		returnString.append("</div><!-- style1_media -->");
		return returnString.toString();
	}

	@Override
	protected String getMessageInformatifLanceur(final Media media) {
		return messageInformatifLanceur;
	}

	public int getHauteurMaxVignette() {
		return hauteurMaxVignette;
	}

	public void setHauteurMaxVignette(final int hauteurMaxVignette) {
		this.hauteurMaxVignette = hauteurMaxVignette;
	}

	public int getLargeurMaxVignette() {
		return largeurMaxVignette;
	}

	public void setLargeurMaxVignette(final int largeurMaxVignette) {
		this.largeurMaxVignette = largeurMaxVignette;
	}
}