/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.style;

import java.util.Collection;

public interface PlayerStyle {

	String getName();

	int getWidth();

	int getHeight();

	/**
	 * Il est possible dans le style de surcharger via cette fonction l'URL du player distant du player qui utilisera ce style.
	 * 
	 * @return retur l'URL du nouveau player distant ou NULL.
	 */
	String getSpecificUrlPlayerDistant();

	/**
	 * Récupérer la liste des noms de propriétés d'initialisations du player. Par exemple, pourront être défini pour certain player : autostart, bgcolor, ...
	 * 
	 * @return L'ensemble des propriété d'initialisation.
	 */
	Collection<String> getListeNomsProprieteInitialisation();

	/**
	 * Récupérer la valeur d'une propriété d'initialisation.
	 * 
	 * @param nomPropriete
	 *            Le nom de la propriété dont on souhaite connaitre la valeur.
	 * @return La valeur ou NULL si la propriété n'est pas définie.
	 */
	String getValeurProprieteInitialisation(String nomPropriete);
}
