/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.style;

import java.util.Collection;
import java.util.Map;

public class PlayerStyleDefaut implements PlayerStyle {

	private int width;

	private int height;

	private String name;

	private Map<String, String> listeProprieteInitialisation;

	private String specificUrlPlayerDistant;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.univ.mediatheque.style.PlayerStyle#getHeight()
	 */
	@Override
	public int getHeight() {
		return this.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.univ.mediatheque.style.PlayerStyle#getListeNomsProprieteInitialisation
	 * ()
	 */
	@Override
	public Collection<String> getListeNomsProprieteInitialisation() {
		if (listeProprieteInitialisation == null) {
			return null;
		} else {
			return this.listeProprieteInitialisation.keySet();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.univ.mediatheque.style.PlayerStyle#getName()
	 */
	@Override
	public String getName() {
		return this.name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.univ.mediatheque.style.PlayerStyle#getSpecificUrlPlayerDistant()
	 */
	@Override
	public String getSpecificUrlPlayerDistant() {
		return specificUrlPlayerDistant;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.univ.mediatheque.style.PlayerStyle#getValeurProprieteInitialisation
	 * (java.lang.String)
	 */
	@Override
	public String getValeurProprieteInitialisation(String nomPropriete) {
		if (listeProprieteInitialisation == null) {
			return null;
		} else {
			return this.listeProprieteInitialisation.get(nomPropriete);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.univ.mediatheque.style.PlayerStyle#getWidth()
	 */
	@Override
	public int getWidth() {
		return this.width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setListeProprieteInitialisation(Map<String, String> listeProprieteInitialisation) {
		this.listeProprieteInitialisation = listeProprieteInitialisation;
	}

	public void setSpecificUrlPlayerDistant(String specificUrlPlayerDistant) {
		this.specificUrlPlayerDistant = specificUrlPlayerDistant;
	}
}
