/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.mediatheque.utils;

import org.apache.commons.lang3.StringEscapeUtils;

public class HTMLUtils {

	public static String HTML_MEDIATHEQUE_LANCEUR_JS = "_MediathequeLuncher";

	public static String HTML_MEDIATHEQUE_LANCEUR_JS_ADD_START = "_MediathequeLuncher.addFunctionLunchable(";

	public static String HTML_MEDIATHEQUE_LANCEUR_JS_ADD_END = ");\n";

	public static String HTML_SCRIPT_JS_OPEN = "<script type=\"text/javascript\">\n//<![CDATA[\n";

	public static String HTML_SCRIPT_JS_CLOSE = "//]]>\n</script>";

	public static String OBJET_JS_ONGLET_MANAGER = "new OngletManager()";

	/**
	 * Ajouter l'exécution d'une fonction JS au chargement de la page HTML.
	 * 
	 * @param fonctionJS
	 *            la fonction à lancer
	 * @param priorite
	 *            La priorité d'écution (entre 0 et 999)
	 * @return le code JS à intégrer dans un script.
	 */
	public static String genererMediathequeLanceurJSAdd(String fonctionJS, int priorite) {
		StringBuilder lanceur = new StringBuilder();
		lanceur.append(HTML_MEDIATHEQUE_LANCEUR_JS_ADD_START);
		lanceur.append("'");
		lanceur.append(StringEscapeUtils.escapeEcmaScript(fonctionJS));
		lanceur.append("',");
		lanceur.append(priorite);
		lanceur.append(HTML_MEDIATHEQUE_LANCEUR_JS_ADD_END);
		return lanceur.toString();
	}
}
