/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.migration;

import java.util.HashMap;

import javax.servlet.jsp.JspWriter;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.database.SOSJDBCProxy;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.univ.objetspartages.om.Mailing;
import com.univ.xhtml.XHTMLFormater;

public class MigrationNewsletters {

	/**
	 * Migrer.
	 *
	 * @param _out
	 *            the _out
	 *
	 * @throws Exception
	 *             the exception
	 */
	public static void migrer(final JspWriter _out) throws Exception {
		_out.println("DEBUT du traitement ...<br />");
		_out.flush();
		final ContextePage ctx = new ContextePage("");
		final Mailing m = new Mailing();
		m.setCtx(ctx);
		m.selectNoCount(", MODELEMAIL T2 WHERE T2.PUBLIC_INTERNE='0' AND SUBSTRING_INDEX(T1.ID_NEWSLETTER,'_',1)=T2.ID_MODELE_MAIL AND T1.EMAIL NOT LIKE '%[%' ORDER BY T1.ID_NEWSLETTER");
		String idNewsletter = "";
		String messageNewsletter = "";
		final HashMap<String, StringBuffer> listeMailsParIdNews = new HashMap<String, StringBuffer>();
		boolean cut = false;
		while (m.nextItem()) {
			cut = false;
			if (idNewsletter.length() > 0 && !m.getIdNewsletter().equals(idNewsletter)) {
				messageNewsletter = "";
			}
			idNewsletter = m.getIdNewsletter();
			if (messageNewsletter.length() == 0) {
				messageNewsletter = m.getMessage();
				//suppression de la seule partie distincte sur un email
				if (messageNewsletter.length() == 65535) {
					cut = true;
				}
				//le mail apparaît dans le lien "cliquez ici"
				messageNewsletter = StringUtils.replace(messageNewsletter, "EMAIL=" + m.getEmail(), "EMAIL=");
				//le code utilisateur peut apparaître dans un lien de désabonnement
				messageNewsletter = StringUtils.remove(messageNewsletter, m.getCodeUtilisateur());
				if (cut) {
					messageNewsletter = StringUtils.substring(messageNewsletter, 0, messageNewsletter.length() - 100);
				}
				/*
				File fold = new File("/Users/alice/Desktop/"+idNewsletter+"/");
				fold.mkdir();

				File f = new File("/Users/alice/Desktop/"+idNewsletter+"/"+idNewsletter+".txt");
				String messageToWrite = StringUtils.replace(messageNewsletter, "\\>(.*?)\\<", "\\>\\n$1\\<");
				FileOutputStream fos = new FileOutputStream(f);
				fos.write(messageToWrite.getBytes());
				fos.close();
				 */
				final String messageTidy = new XHTMLFormater().parseContenuToolbox(messageNewsletter);
				_out.println("Suppression des enregistrements en trop pour la newsletter <b>" + m.getObjet() + "</b> - " + idNewsletter + " : <div style=\"background-color:white;border:1px black solid;width:1000px;height:300px;overflow:auto;\">" + messageTidy + "</div><br />");
				_out.flush();
			} else {
				StringBuffer listeEmail = listeMailsParIdNews.get(idNewsletter);
				if (listeEmail == null) {
					listeEmail = new StringBuffer("");
				}
				listeEmail.append("[").append(m.getEmail()).append("]");
				listeMailsParIdNews.put(idNewsletter, listeEmail);
				//suppression de l'enregistrement puisqu'il est en doublon avec le précédent
				m.delete();
			}
		}
		SOSJDBCProxy.cleanConnection(ctx.getConnection());
		_out.println("Mise à jour de la liste des destinataires<br />");
		for (final String idNews : listeMailsParIdNews.keySet()) {
			if (listeMailsParIdNews.get(idNews).length() > 0) {
				m.select("", idNews);
				if (m.nextItem()) {
					_out.println("mise à jour id_newsletter " + idNews + " avec la liste des destinataires : " + listeMailsParIdNews.get(idNews) + "<br />");
					_out.flush();
					String oldEmail = m.getEmail();
					if (oldEmail.length() > 0 && oldEmail.indexOf("[") == -1) {
						oldEmail = "[" + oldEmail + "]";
					}
					m.setEmail(listeMailsParIdNews.get(idNews).append(oldEmail).toString());
					m.update();
				}
			}
		}
		_out.println("<br /><br />FIN du traitement.");
		ctx.release();
	}
}
