/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 23 mars 2005
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.univ.migration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.servlet.jsp.JspWriter;

import com.jsbsoft.jtf.webutils.ContextePage;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ImageInfo;

/**
 * The Class MigrationPhotosFichiergw.
 *
 * @author Romain
 *
 *         To change the template for this generated type comment go to Window - Preferences - Java - Code Generation - Code and Comments
 */
public class MigrationPhotosFichiergw {

    /**
     * Migrer.
     *
     * @param out
     *            the out
     *
     * @throws Exception
     *             the exception
     */
    public static void migrer(final JspWriter out) throws Exception {
        out.println("DEBUT du traitement ...<br />");
        out.flush();
        final ContextePage ctx = new ContextePage("");
        // migration des fichiergw en ressource + creation d'un media
        setSpecificDataImages(out, ctx);
        out.flush();
        out.println("<br /><br />FIN du traitement.");
        ctx.release();
    }

    /**
     * Renseigne le champ SPECIFIC DATA des éléments de MEDIA dont ce champ n'a pas ete renseigne lors de la migration Il s'agit de photos dont les infos etaient stockees dans la
     * table FICHIERGW
     *
     * @param out
     *            the out
     * @param ctx
     *            the ctx
     *
     * @throws Exception
     *             the exception
     */
    public static void setSpecificDataImages(final JspWriter out, final ContextePage ctx) throws Exception {
        out.println("<br />*** Alimentation du champ SPECIFIC_DATA des images de la table MEDIA*** <br />");
        String sPath;
        final Media media = new Media();
        media.setCtx(ctx);
        media.init();
        int nCount = 0;
        //Recherche des MEDIA images dont les infos de taille d'image est vide
        final String requete = "where SPECIFIC_DATA='' and (FORMAT='image/gif' or FORMAT ='image/jpeg')";
        if (media.select(requete) > 0) {
            while (media.nextItem()) {
                //Recuperation du chemin de l'image
                sPath = media.getPathAbsolu();
                //Recuperation des informations de l'image
                final ImageInfo ii = new ImageInfo();
                try {
                    final InputStream inpStream = new FileInputStream(sPath);
                    if (inpStream != null) {
                        //Création du champ SPECIFIC_DATA
                        ii.setInput(inpStream);
                        ii.check();
                        ii.close();
                        String sDatas = "";
                        final Properties properties = new Properties();
                        properties.load(new ByteArrayInputStream(sDatas.getBytes()));
                        properties.setProperty("LARGEUR", (new Integer(ii.getWidth())).toString());
                        properties.setProperty("HAUTEUR", (new Integer(ii.getHeight())).toString());
                        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        properties.store(baos, "");
                        sDatas = baos.toString();
                        media.setSpecificData(sDatas);
                        //Mise à jour de l'enregistrement en base
                        media.update();
                        out.println("Image " + sPath + " => Mise à jour de MEDIA.SPECIFIC_DATA : sDatas <br />");
                        nCount++;
                    }
                } catch (final IOException e) {
                    out.println("Erreur recupération informations Fichier :" + sPath + " Exception :" + e + "<br />");
                }
            }
            out.println("Nombre d'images migrees :" + nCount + "<br />");
        }
    }
}