/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.migration;

import java.io.File;

import javax.servlet.jsp.JspWriter;

import org.slf4j.LoggerFactory;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.FileAppender;

import com.jsbsoft.jtf.database.SOSJDBCProxy;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.mediatheque.Mediatheque;
import com.univ.mediatheque.utils.MediathequeHelper;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.util.RessourceUtil;
import com.univ.utils.FileUtil;

// TODO: Auto-generated Javadoc
/**
 * The Class MigrationPhototheque.
 * 
 * @author Romain
 * 
 *         To change the template for this generated type comment go to Window - Preferences - Java - Code Generation - Code and Comments
 */
public class MigrationRessources implements Runnable {

	private static Logger logger = (Logger) LoggerFactory.getLogger(MigrationRessources.class);

	private static JspWriter OutWriter = null;

	public static void main(final String[] args) {
		final MigrationRessources capture = new MigrationRessources();
		final Thread thread = (new Thread(capture));
		thread.start();
		try {
			thread.join();
		} catch (final Exception e) {
			logger.error("Echec thread.join()", e);
		}
	}

	/**
	 * Migrer.
	 * 
	 * @param out
	 *            the out
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public static void migrer(final JspWriter out) throws Exception {
		OutWriter = out;
		FileAppender<ILoggingEvent> appender;
		final MigrationRessources mig = new MigrationRessources();
		appender = mig.initialisationLog();
		mig.securiserAll();
		logger.detachAppender(appender);
		//appender.close();
	}

	public void securiserAll() throws Exception {
		ecrireLog("Début traitement securisation ressources : " + new java.util.Date(System.currentTimeMillis()), "INFO");
		//out.flush();
		final ContextePage ctx = new ContextePage("");
		ctx.setConnectionLongue(true);
		final String pathFichierSecurise = RessourceUtil.getAbsolutePath();
		final String pathMediaPublic = MediathequeHelper.getAbsolutePath();
		int compteurPrive = 0;
		int compteurPublic = 0;
		int erreur = 0;
		final Mediatheque mediatheque = Mediatheque.getInstance();
		for (final String type : mediatheque.getTypesMedia().keySet()) {
			// on recupère le paramètre par defaut
			final String secure = PropertyHelper.getCoreProperty("mediatheque.secure." + type.toLowerCase());
			// fichier non mutualise et prive
			if ("2".equals(secure)) {
				final Media media = new Media();
				media.init();
				media.setCtx(ctx);
				media.select("WHERE TYPE_RESSOURCE='" + type.toLowerCase() + "' AND IS_MUTUALISE NOT IN ('0','2')");
				while (media.nextItem()) {
					try {
						// media local et non présent sous /WEB-INF/fichiergw/
						if (media.isLocal()) {
							final File source = new File(media.getPathAbsolu());
							if (source.exists()) {
								final File destination = new File(pathFichierSecurise + "/" + media.getUrl());
								FileUtil.copierFichier(source, destination);
								if (destination.exists()) {
									source.delete();
									media.setIsMutualise("2");
									media.update();
									compteurPrive++;
								}
							}
						}
					} catch (final Exception e) {
						erreur++;
						ecrireLog("Erreur copie fichier " + media.getPathAbsolu(), "ERROR");
					}
				}// next fichier
			} else if ("1".equals(secure)) {
				final Media media = new Media();
				media.init();
				media.setCtx(ctx);
				media.select("WHERE TYPE_RESSOURCE='" + type.toLowerCase() + "' AND IS_MUTUALISE NOT IN ('0','1')");
				while (media.nextItem()) {
					try {
						// media local et non présent sous /medias/type/
						if (media.isLocal()) {
							final File source = new File(media.getPathAbsolu());
							if (source.exists()) {
								final File destination = new File(pathMediaPublic + "/" + media.getTypeRessource().toLowerCase() + "/" + media.getUrl());
								FileUtil.copierFichier(source, destination);
								if (destination.exists()) {
									source.delete();
									media.setIsMutualise("1");
									media.update();
									compteurPublic++;
								}
							}
						}
					} catch (final Exception e) {
						erreur++;
						ecrireLog("Erreur copie fichier " + media.getPathAbsolu(), "ERROR");
					}
				}
			}
			SOSJDBCProxy.cleanConnection(ctx.getConnection());
		}
		// fin for
		ecrireLog("Bilan", "INFO");
		ecrireLog(compteurPrive + " ressource(s) sécurisée(s)", "INFO");
		ecrireLog(compteurPublic + " ressource(s) rendue(s) publique(s)", "INFO");
		ecrireLog(erreur + " erreur(s)", "INFO");
		//out.flush();
		ctx.release();
		ecrireLog("Fin traitement securisation ressources : " + new java.util.Date(System.currentTimeMillis()), "INFO");
	}

	protected void moveFile(final String destinationPath) {}

	@Override
	public void run() {
		FileAppender<ILoggingEvent> appender;
		// TODO Auto-generated method stub
		try {
			// On crée le nouveau 'logger'.
			appender = initialisationLog();
			securiserAll();
			logger.detachAppender(appender);
			//appender.close();
		} catch (final Exception e) {
			logger.error("Erreur lors du traitement de migration > Message :" + e.getMessage() + "StackTrace :");
		}
	}

	private FileAppender<ILoggingEvent> initialisationLog() throws Exception {
		FileAppender<ILoggingEvent> appender = null;
		String sFileLog = "";
		try {
			// On crée le nouveau 'logger'.
			final String logPath = WebAppUtil.getLogsPath();
			sFileLog = logPath + File.separator + "migrationRessource.log";
			appender = new FileAppender<ILoggingEvent>();
			// On 'démarre' l'appender.
			appender.setEncoder(new PatternLayoutEncoder());
			appender.setAppend(false);
			appender.setFile(sFileLog);
			logger.detachAndStopAllAppenders();
			logger.setAdditive(false);
			// On ajoute l'appender file au logger.
			logger.addAppender(appender);
		} catch (final Exception e) {
			// TODO Auto-generated catch block
			logger.error("Erreur initialisation fichier de log migrationRessource.log");
		}
		return appender;
	}

	private static void ecrireLog(final String sTexteLog, final String sMode) throws Exception {
		if (OutWriter != null) {
			OutWriter.println(sTexteLog + "<br />");
			OutWriter.flush();
		}
		if (sMode.equals("INFO")) {
			logger.info(sTexteLog);
		} else if (sMode.equals("ERROR")) {
			logger.error(sTexteLog);
		} else if (sMode.equals("DEBUG")) {
			logger.debug(sTexteLog);
		}
	}
}
