/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 12 mai 2005
 *
 * Test perfs groupes dynamiques
 */
package com.univ.misc;

import java.util.Map;
import java.util.Vector;

import com.univ.utils.ContexteDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.InfoBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.RequeteGroupeDynamique;
import com.univ.objetspartages.om.Utilisateur;

/**
 * The Class RequeteDynamiqueGroupeParNom.
 * 
 * @author jeanseb
 * 
 *         Gestion d'un groupe dynamique de test qui renvoie tous les utilisateurs pour tester les perfs de k-portal sur des volumes importants
 */
@Deprecated
public class RequeteDynamiqueGroupeParNom extends RequeteGroupeDynamique {

	private final Logger LOG = LoggerFactory.getLogger(RequeteDynamiqueGroupeParNom.class);

	public RequeteDynamiqueGroupeParNom() {
		super();
		setNomRequete("REQUETE_GROUPE_NOM");
	}

	/* (non-Javadoc)
	 * @see com.univ.objetspartages.om.RequeteGroupeDynamique#getVecteurUtilisateurs(java.lang.String)
	 */
	@Override
	public Vector<String> getVecteurUtilisateurs(final String _requeteGroupe) throws Exception {
		LOG.debug("RequeteDynamiquePerfs.getVecteurUtilisateur (" + _requeteGroupe + ")");
		String select = "";
		if (_requeteGroupe.lastIndexOf("_") != -1) {
			select = "WHERE NOM LIKE '" + _requeteGroupe.substring(_requeteGroupe.lastIndexOf("_") + 1) + "%'";
		}
		final Vector<String> res = new Vector<>();
		try (ContexteDao ctx = new ContexteDao()) {
			final Utilisateur utilisateur = new Utilisateur();
			utilisateur.setCtx(ctx);
			utilisateur.select(select);
			while (utilisateur.nextItem()) {
				res.add(utilisateur.getCode());
			}
		}
		return res;
	}

	/* (non-Javadoc)
	 * @see com.univ.objetspartages.om.RequeteGroupeDynamique#getGroupesUtilisateur(java.lang.String)
	 */
	@Override
	public Vector<String> getGroupesUtilisateur(final String codeUtilisateur) throws Exception {
		LOG.debug("RequeteDynamiquePerfs.getGroupesUtilisateur ()");
		final Vector<String> res = new Vector<>();
		final Utilisateur utilisateur = Utilisateur.getUtilisateur(codeUtilisateur);
		// on recupere les groupes gérés par cette requete dynamique
		for (final InfosGroupeDsi infos : Groupedsi.getListeGroupesDynamiques()) {
			if (infos.getRequete().equals(getNomRequete())) {
				String select = "";
				if (infos.getCode().lastIndexOf("_") != -1) {
					select = infos.getCode().substring(infos.getCode().lastIndexOf("_") + 1);
				}
				if (utilisateur.getNom().startsWith(select)) {
					res.add(infos.getCode());
				}
			}
		}
		return res;
	}

	/* (non-Javadoc)
	 * @see com.univ.objetspartages.om.RequeteGroupeDynamique#synchroniserGroupes(int, java.util.Map)
	 */
	/**
	 * Synchroniser groupes.
	 * 
	 * @param action
	 *            the action
	 * @param mapProprietes
	 *            the map proprietes
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void synchroniserGroupes(final int action, final Map mapProprietes) throws Exception {
		LOG.debug("RequeteGroupeFormation.synchroniserGroupes ()");
	}

	/* (non-Javadoc)
	 * @see com.univ.objetspartages.om.RequeteGroupeDynamique#estGereParReqDyn(java.lang.String)
	 */
	@Override
	protected boolean estGereParReqDyn(final String requeteGroupe) {
		return true;
	}

	/**
	 * Preparer principal.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param groupe
	 *            the groupe
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public void preparerPRINCIPAL(final InfoBean infoBean, final Groupedsi groupe) throws Exception {}

}
