/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.multisites.service;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.univ.multisites.InfosSite;

/**
 * Factory à utiliser pour récupérer le {@link ServiceInfosSite} déclaré dans l'application.
 * 
 * @author pierre.cosson
 * 
 */
public class ServiceInfosSiteFactory {

	public static final String ID_BEAN = "serviceInfosSiteFactory";

	private ServiceInfosSite serviceInfosSiteInstance = null;

	/**
	 * Récupérer le singleton de la factory.
	 * 
	 * @return
	 */
	private static ServiceInfosSiteFactory getInstance() {
		return (ServiceInfosSiteFactory) ApplicationContextManager.getCoreContextBean(ID_BEAN);
	}

	public void setServiceInfosSite(ServiceInfosSite serviceInfosSite) {
		serviceInfosSiteInstance = serviceInfosSite;
	}

	/**
	 * Charger l'instance du service {@link ServiceInfosSite} permettant de lister les {@link InfosSite} de l'application.
	 * 
	 * @return l'instance (le singleton)
	 */
	public static ServiceInfosSite getServiceInfosSite() {
		return getInstance().serviceInfosSiteInstance;
	}
}
