/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.bean;

import java.io.Serializable;
import java.sql.Date;

import org.codehaus.jackson.map.annotate.JsonView;

import com.univ.utils.json.Views;

public class AbstractFicheBean extends AbstractPersistenceBean implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2078943141200588647L;

	/** The code. */
	@JsonView({ Views.BackOfficeView.class, Views.FrontOfficeView.class, Views.PublicView.class })
	protected String code = null;

	/** The titre. */
	@JsonView({ Views.BackOfficeView.class, Views.FrontOfficeView.class, Views.PublicView.class })
	protected String titre = null;

	/** The code rubrique. */
	@JsonView(Views.BackOfficeView.class)
	protected String codeRubrique = null;

	/** The code rattachement. */
	@JsonView(Views.BackOfficeView.class)
	protected String codeRattachement = null;

	/** The meta keywords. */
	@JsonView(Views.BackOfficeView.class)
	protected String metaKeywords = null;

	/** The meta description. */
	@JsonView(Views.BackOfficeView.class)
	protected String metaDescription = null;

	/** The titre encadre. */
	@JsonView(Views.BackOfficeView.class)
	protected String titreEncadre = null;

	/** The contenu encadre. */
	@JsonView(Views.BackOfficeView.class)
	protected String contenuEncadre = null;

	/** The encadre recherche. */
	@JsonView(Views.BackOfficeView.class)
	protected String encadreRecherche = null;

	/** The encadre recherche bis. */
	@JsonView(Views.BackOfficeView.class)
	protected String encadreRechercheBis = null;

	/** The date alerte. */
	@JsonView(Views.BackOfficeView.class)
	protected Date dateAlerte = null;

	/** The message alerte. */
	@JsonView(Views.BackOfficeView.class)
	protected String messageAlerte = null;

	/** The date creation. */
	@JsonView(Views.BackOfficeView.class)
	protected Date dateCreation = null;

	/** The date proposition. */
	@JsonView(Views.BackOfficeView.class)
	protected Date dateProposition = null;

	/** The date validation. */
	@JsonView(Views.BackOfficeView.class)
	protected Date dateValidation = null;

	/** The date modification. */
	@JsonView(Views.BackOfficeView.class)
	protected Date dateModification = null;

	/** The code redacteur. */
	@JsonView(Views.BackOfficeView.class)
	protected String codeRedacteur = null;

	/** The code validation. */
	@JsonView(Views.BackOfficeView.class)
	protected String codeValidation = null;

	/** The langue. */
	@JsonView(Views.BackOfficeView.class)
	protected String langue = null;

	/** The etat objet. */
	@JsonView(Views.BackOfficeView.class)
	protected String etatObjet = null;

	/** The nb hits. */
	@JsonView(Views.BackOfficeView.class)
	protected Long nbHits = null;

	public void init(AbstractFicheBean bean) {
		this.id = bean.id;
		this.code = bean.code;
		this.titre = bean.titre;
		this.codeRubrique = bean.codeRubrique;
		this.codeRattachement = bean.codeRattachement;
		this.metaKeywords = bean.metaKeywords;
		this.metaDescription = bean.metaDescription;
		this.titreEncadre = bean.titreEncadre;
		this.contenuEncadre = bean.contenuEncadre;
		this.encadreRecherche = bean.encadreRecherche;
		this.encadreRechercheBis = bean.encadreRechercheBis;
		this.dateAlerte = bean.dateAlerte;
		this.messageAlerte = bean.messageAlerte;
		this.dateCreation = bean.dateCreation;
		this.dateProposition = bean.dateProposition;
		this.dateValidation = bean.dateValidation;
		this.dateModification = bean.dateModification;
		this.codeRedacteur = bean.codeRedacteur;
		this.codeValidation = bean.codeValidation;
		this.langue = bean.langue;
		this.etatObjet = bean.etatObjet;
		this.nbHits = bean.nbHits;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getTitre() {
		return titre;
	}

	public void setTitre(String titre) {
		this.titre = titre;
	}

	public String getCodeRubrique() {
		return codeRubrique;
	}

	public void setCodeRubrique(String codeRubrique) {
		this.codeRubrique = codeRubrique;
	}

	public String getCodeRattachement() {
		return codeRattachement;
	}

	public void setCodeRattachement(String codeRattachement) {
		this.codeRattachement = codeRattachement;
	}

	public String getMetaKeywords() {
		return metaKeywords;
	}

	public void setMetaKeywords(String metaKeywords) {
		this.metaKeywords = metaKeywords;
	}

	public String getMetaDescription() {
		return metaDescription;
	}

	public void setMetaDescription(String metaDescription) {
		this.metaDescription = metaDescription;
	}

	public String getTitreEncadre() {
		return titreEncadre;
	}

	public void setTitreEncadre(String titreEncadre) {
		this.titreEncadre = titreEncadre;
	}

	public String getContenuEncadre() {
		return contenuEncadre;
	}

	public void setContenuEncadre(String contenuEncadre) {
		this.contenuEncadre = contenuEncadre;
	}

	public String getEncadreRecherche() {
		return encadreRecherche;
	}

	public void setEncadreRecherche(String encadreRecherche) {
		this.encadreRecherche = encadreRecherche;
	}

	public String getEncadreRechercheBis() {
		return encadreRechercheBis;
	}

	public void setEncadreRechercheBis(String encadreRechercheBis) {
		this.encadreRechercheBis = encadreRechercheBis;
	}

	public Date getDateAlerte() {
		return dateAlerte;
	}

	public void setDateAlerte(Date dateAlerte) {
		this.dateAlerte = dateAlerte;
	}

	public String getMessageAlerte() {
		return messageAlerte;
	}

	public void setMessageAlerte(String messageAlerte) {
		this.messageAlerte = messageAlerte;
	}

	public Date getDateCreation() {
		return dateCreation;
	}

	public void setDateCreation(Date dateCreation) {
		this.dateCreation = dateCreation;
	}

	public Date getDateProposition() {
		return dateProposition;
	}

	public void setDateProposition(Date dateProposition) {
		this.dateProposition = dateProposition;
	}

	public Date getDateValidation() {
		return dateValidation;
	}

	public void setDateValidation(Date dateValidation) {
		this.dateValidation = dateValidation;
	}

	public Date getDateModification() {
		return dateModification;
	}

	public void setDateModification(Date dateModification) {
		this.dateModification = dateModification;
	}

	public String getCodeRedacteur() {
		return codeRedacteur;
	}

	public void setCodeRedacteur(String codeRedacteur) {
		this.codeRedacteur = codeRedacteur;
	}

	public String getCodeValidation() {
		return codeValidation;
	}

	public void setCodeValidation(String codeValidation) {
		this.codeValidation = codeValidation;
	}

	public String getLangue() {
		return langue;
	}

	public void setLangue(String langue) {
		this.langue = langue;
	}

	public String getEtatObjet() {
		return etatObjet;
	}

	public void setEtatObjet(String etatObjet) {
		this.etatObjet = etatObjet;
	}

	public Long getNbHits() {
		return nbHits;
	}

	public void setNbHits(Long nbHits) {
		this.nbHits = nbHits;
	}
}
