/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.bean;

import java.sql.Date;

import com.kportal.cms.objetspartages.annotation.GetterAnnotation;
import com.kportal.cms.objetspartages.annotation.SetterAnnotation;

// TODO: Auto-generated Javadoc
/**
 * Classe d'acces aux donnees pour article.
 */
public class ArticleBean extends AbstractFicheBean {

	private static final long serialVersionUID = 5378745888019802640L;

	/** The sous titre. */
	protected String sousTitre = null;

	/** The date article. */
	protected Date dateArticle = null;

	/** The id vignette. */
	protected Long idVignette = null;

	/** The chapeau. */
	protected String chapeau = null;

	/** The corps. */
	protected String corps = null;

	/** The thematique. */
	protected String thematique = null;

	/** The ordre. */
	protected Integer ordre = null;

	/** The diffusion public vise. */
	protected String diffusionPublicVise = null;

	/** The diffusion mode restriction. */
	protected String diffusionModeRestriction = null;

	/** The diffusion public vise restriction. */
	protected String diffusionPublicViseRestriction = null;

	/**
	 * initialise un ArticleBean à partir de celui fourni en paramètre
	 *
	 * @param bean
	 *            le bean servant à initialiser cette instance
	 */
	public void init(final ArticleBean bean) {
		super.init(bean);
		this.sousTitre = bean.sousTitre;
		this.dateArticle = bean.dateArticle;
		this.idVignette = bean.idVignette;
		this.chapeau = bean.chapeau;
		this.corps = bean.corps;
		this.thematique = bean.thematique;
		this.ordre = bean.ordre;
		this.diffusionPublicVise = bean.diffusionPublicVise;
		this.diffusionModeRestriction = bean.diffusionModeRestriction;
		this.diffusionPublicViseRestriction = bean.diffusionPublicViseRestriction;
	}

	/**
	 * Instantiates a new article bean.
	 */
	public ArticleBean() {
		super();
	}

	/**
	 * Gets the chapeau.
	 *
	 * @return the chapeau
	 */
	public String getChapeau() {
		return chapeau;
	}

	/**
	 * Sets the chapeau.
	 *
	 * @param chapeau
	 *            the chapeau to set
	 */
	public void setChapeau(final String chapeau) {
		this.chapeau = chapeau;
	}

	/**
	 * Gets the corps.
	 *
	 * @return the corps
	 */
	@GetterAnnotation(isToolbox = true)
	public String getCorps() {
		return corps;
	}

	/**
	 * Sets the corps.
	 *
	 * @param corps
	 *            the corps to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setCorps(final String corps) {
		this.corps = corps;
	}

	/**
	 * Gets the date article.
	 *
	 * @return the dateArticle
	 */
	public Date getDateArticle() {
		return dateArticle;
	}

	/**
	 * Sets the date article.
	 *
	 * @param dateArticle
	 *            the dateArticle to set
	 */
	public void setDateArticle(final Date dateArticle) {
		this.dateArticle = dateArticle;
	}

	/**
	 * Gets the id article.
	 *
	 * @return the idArticle
	 */
	public Long getIdArticle() {
		return id;
	}

	/**
	 * Sets the id article.
	 *
	 * @param idArticle
	 *            the idArticle to set
	 */
	public void setIdArticle(final Long idArticle) {
		this.id = idArticle;
	}

	/**
	 * Gets the id vignette.
	 *
	 * @return the idVignette
	 */
	public Long getIdVignette() {
		return idVignette;
	}

	/**
	 * Sets the id vignette.
	 *
	 * @param idVignette
	 *            the idVignette to set
	 */
	public void setIdVignette(final Long idVignette) {
		this.idVignette = idVignette;
	}

	/**
	 * Gets the ordre.
	 *
	 * @return the ordre
	 */
	public Integer getOrdre() {
		return ordre;
	}

	/**
	 * Sets the ordre.
	 *
	 * @param ordre
	 *            the ordre to set
	 */
	public void setOrdre(final Integer ordre) {
		this.ordre = ordre;
	}

	/**
	 * Gets the sous titre.
	 *
	 * @return the sousTitre
	 */
	public String getSousTitre() {
		return sousTitre;
	}

	/**
	 * Sets the sous titre.
	 *
	 * @param sousTitre
	 *            the sousTitre to set
	 */
	public void setSousTitre(final String sousTitre) {
		this.sousTitre = sousTitre;
	}

	/**
	 * Gets the thematique.
	 *
	 * @return the thematique
	 */
	public String getThematique() {
		return thematique;
	}

	/**
	 * Sets the thematique.
	 *
	 * @param thematique
	 *            the thematique to set
	 */
	public void setThematique(final String thematique) {
		this.thematique = thematique;
	}

	public String getDiffusionPublicVise() {
		return diffusionPublicVise;
	}

	public void setDiffusionPublicVise(final String diffusionPublicVise) {
		this.diffusionPublicVise = diffusionPublicVise;
	}

	public String getDiffusionModeRestriction() {
		return diffusionModeRestriction;
	}

	public void setDiffusionModeRestriction(final String diffusionModeRestriction) {
		this.diffusionModeRestriction = diffusionModeRestriction;
	}

	public String getDiffusionPublicViseRestriction() {
		return diffusionPublicViseRestriction;
	}

	public void setDiffusionPublicViseRestriction(final String diffusionPublicViseRestriction) {
		this.diffusionPublicViseRestriction = diffusionPublicViseRestriction;
	}
}
