/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;

public class LibelleBean {

	private String code;

	private String type;

	private Hashtable<String, String> libellesLangues;

	private Collection<String> languesPossiblesPourTraduction;

	private Long idLibelle;

	private boolean libelleSupprimable;

	public LibelleBean() {
		super();
		this.libellesLangues = new Hashtable<String, String>();
		this.languesPossiblesPourTraduction = new ArrayList<String>();
	}

	public String getCode() {
		return code;
	}

	public void setCode(final String code) {
		this.code = code;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public Hashtable<String, String> getLibellesLangues() {
		return libellesLangues;
	}

	public void setLibellesLangues(final Hashtable<String, String> libellesLangues) {
		this.libellesLangues = libellesLangues;
	}

	public Collection<String> getLanguesPossiblesPourTraduction() {
		return languesPossiblesPourTraduction;
	}

	public void setLanguesPossiblesPourTraduction(final Collection<String> languesPossiblesPourTraduction) {
		this.languesPossiblesPourTraduction = languesPossiblesPourTraduction;
	}

	public Long getIdLibelle() {
		return idLibelle;
	}

	public void setIdLibelle(final Long idLibelle) {
		this.idLibelle = idLibelle;
	}

	public boolean isLibelleSupprimable() {
		return libelleSupprimable;
	}

	public void canLibelleSupprimable(final boolean canLibelleSupprimable) {
		this.libelleSupprimable = canLibelleSupprimable;
	}

	public void addLibelle(final String langue, final String libelle) {
		this.libellesLangues.put(langue, libelle);
	}
}
