/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.bean;

import java.io.Serializable;
import java.sql.Date;

import com.kportal.cms.objetspartages.annotation.GetterAnnotation;
import com.kportal.cms.objetspartages.annotation.SetterAnnotation;

// TODO: Auto-generated Javadoc
/**
 * Classe d'acces aux donnees pour pagelibre.
 */
public class PagelibreBean implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2834597145328529412L;

	/**
	 * Instantiates a new pagelibre bean.
	 */
	public PagelibreBean() {
		super();
	}

	/** The id pagelibre. */
	private Long idPagelibre = null;

	/** The titre. */
	private String titre = null;

	/** The rattachement bandeau. */
	private String rattachementBandeau = null;

	/** The contenu. */
	protected String contenu = null;

	/** The complements. */
	protected String complements = null;

	/** The code. */
	protected String code = null;

	/** The code rubrique. */
	protected String codeRubrique = null;

	/** The code rattachement. */
	protected String codeRattachement = null;

	/** The meta keywords. */
	protected String metaKeywords = null;

	/** The meta description. */
	protected String metaDescription = null;

	/** The titre encadre. */
	protected String titreEncadre = null;

	/** The contenu encadre. */
	protected String contenuEncadre = null;

	/** The encadre recherche. */
	protected String encadreRecherche = null;

	/** The encadre recherche bis. */
	protected String encadreRechercheBis = null;

	/** The date alerte. */
	protected Date dateAlerte = null;

	/** The message alerte. */
	protected String messageAlerte = null;

	/** The date creation. */
	protected Date dateCreation = null;

	/** The date proposition. */
	protected Date dateProposition = null;

	/** The date validation. */
	protected Date dateValidation = null;

	/** The date modification. */
	protected Date dateModification = null;

	/** The code redacteur. */
	protected String codeRedacteur = null;

	/** The code validation. */
	protected String codeValidation = null;

	/** The langue. */
	protected String langue = null;

	/** The etat objet. */
	protected String etatObjet = null;

	/** The nb hits. */
	protected Long nbHits = null;

	/** The diffusion public vise. */
	protected String diffusionPublicVise = null;

	/** The diffusion mode restriction. */
	protected String diffusionModeRestriction = null;

	/** The diffusion public vise restriction. */
	protected String diffusionPublicViseRestriction = null;

	/**
	 * Inits the.
	 * 
	 * @param bean
	 *            the bean
	 */
	public void init(PagelibreBean bean) {
		this.idPagelibre = bean.idPagelibre;
		this.titre = bean.titre;
		this.rattachementBandeau = bean.rattachementBandeau;
		this.contenu = bean.contenu;
		this.complements = bean.complements;
		this.code = bean.code;
		this.codeRubrique = bean.codeRubrique;
		this.codeRattachement = bean.codeRattachement;
		this.metaKeywords = bean.metaKeywords;
		this.metaDescription = bean.metaDescription;
		this.titreEncadre = bean.titreEncadre;
		this.contenuEncadre = bean.contenuEncadre;
		this.encadreRecherche = bean.encadreRecherche;
		this.encadreRechercheBis = bean.encadreRechercheBis;
		this.dateAlerte = bean.dateAlerte;
		this.messageAlerte = bean.messageAlerte;
		this.dateCreation = bean.dateCreation;
		this.dateProposition = bean.dateProposition;
		this.dateValidation = bean.dateValidation;
		this.dateModification = bean.dateModification;
		this.codeRedacteur = bean.codeRedacteur;
		this.codeValidation = bean.codeValidation;
		this.langue = bean.langue;
		this.etatObjet = bean.etatObjet;
		this.nbHits = bean.nbHits;
		this.diffusionPublicVise = bean.diffusionPublicVise;
		this.diffusionModeRestriction = bean.diffusionModeRestriction;
		this.diffusionPublicViseRestriction = bean.diffusionPublicViseRestriction;
	}

	/**
	 * Gets the code.
	 * 
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * Sets the code.
	 * 
	 * @param code
	 *            the code to set
	 */
	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * Gets the code rattachement.
	 * 
	 * @return the codeRattachement
	 */
	public String getCodeRattachement() {
		return codeRattachement;
	}

	/**
	 * Sets the code rattachement.
	 * 
	 * @param codeRattachement
	 *            the codeRattachement to set
	 */
	public void setCodeRattachement(String codeRattachement) {
		this.codeRattachement = codeRattachement;
	}

	/**
	 * Gets the code redacteur.
	 * 
	 * @return the codeRedacteur
	 */
	public String getCodeRedacteur() {
		return codeRedacteur;
	}

	/**
	 * Sets the code redacteur.
	 * 
	 * @param codeRedacteur
	 *            the codeRedacteur to set
	 */
	public void setCodeRedacteur(String codeRedacteur) {
		this.codeRedacteur = codeRedacteur;
	}

	/**
	 * Gets the code rubrique.
	 * 
	 * @return the codeRubrique
	 */
	public String getCodeRubrique() {
		return codeRubrique;
	}

	/**
	 * Sets the code rubrique.
	 * 
	 * @param codeRubrique
	 *            the codeRubrique to set
	 */
	public void setCodeRubrique(String codeRubrique) {
		this.codeRubrique = codeRubrique;
	}

	/**
	 * Gets the code validation.
	 * 
	 * @return the codeValidation
	 */
	public String getCodeValidation() {
		return codeValidation;
	}

	/**
	 * Sets the code validation.
	 * 
	 * @param codeValidation
	 *            the codeValidation to set
	 */
	public void setCodeValidation(String codeValidation) {
		this.codeValidation = codeValidation;
	}

	/**
	 * Gets the complements.
	 * 
	 * @return the complements
	 */
	@GetterAnnotation(isToolbox = true)
	public String getComplements() {
		return complements;
	}

	/**
	 * Sets the complements.
	 * 
	 * @param complements
	 *            the complements to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setComplements(String complements) {
		this.complements = complements;
	}

	/**
	 * Gets the contenu.
	 * 
	 * @return the contenu
	 */
	@GetterAnnotation(isToolbox = true)
	public String getContenu() {
		return contenu;
	}

	/**
	 * Sets the contenu.
	 * 
	 * @param contenu
	 *            the contenu to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setContenu(String contenu) {
		this.contenu = contenu;
	}

	/**
	 * Gets the contenu encadre.
	 * 
	 * @return the contenuEncadre
	 */
	@GetterAnnotation(isToolbox = true)
	public String getContenuEncadre() {
		return contenuEncadre;
	}

	/**
	 * Sets the contenu encadre.
	 * 
	 * @param contenuEncadre
	 *            the contenuEncadre to set
	 */
	@SetterAnnotation(isToolbox = true)
	public void setContenuEncadre(String contenuEncadre) {
		this.contenuEncadre = contenuEncadre;
	}

	/**
	 * Gets the date alerte.
	 * 
	 * @return the dateAlerte
	 */
	public Date getDateAlerte() {
		return dateAlerte;
	}

	/**
	 * Sets the date alerte.
	 * 
	 * @param dateAlerte
	 *            the dateAlerte to set
	 */
	public void setDateAlerte(Date dateAlerte) {
		this.dateAlerte = dateAlerte;
	}

	/**
	 * Gets the date creation.
	 * 
	 * @return the dateCreation
	 */
	public Date getDateCreation() {
		return dateCreation;
	}

	/**
	 * Sets the date creation.
	 * 
	 * @param dateCreation
	 *            the dateCreation to set
	 */
	public void setDateCreation(Date dateCreation) {
		this.dateCreation = dateCreation;
	}

	/**
	 * Gets the date modification.
	 * 
	 * @return the dateModification
	 */
	public Date getDateModification() {
		return dateModification;
	}

	/**
	 * Sets the date modification.
	 * 
	 * @param dateModification
	 *            the dateModification to set
	 */
	public void setDateModification(Date dateModification) {
		this.dateModification = dateModification;
	}

	/**
	 * Gets the date proposition.
	 * 
	 * @return the dateProposition
	 */
	public Date getDateProposition() {
		return dateProposition;
	}

	/**
	 * Sets the date proposition.
	 * 
	 * @param dateProposition
	 *            the dateProposition to set
	 */
	public void setDateProposition(Date dateProposition) {
		this.dateProposition = dateProposition;
	}

	/**
	 * Gets the date validation.
	 * 
	 * @return the dateValidation
	 */
	public Date getDateValidation() {
		return dateValidation;
	}

	/**
	 * Sets the date validation.
	 * 
	 * @param dateValidation
	 *            the dateValidation to set
	 */
	public void setDateValidation(Date dateValidation) {
		this.dateValidation = dateValidation;
	}

	/**
	 * Gets the diffusion mode restriction.
	 * 
	 * @return the diffusionModeRestriction
	 */
	public String getDiffusionModeRestriction() {
		return diffusionModeRestriction;
	}

	/**
	 * Sets the diffusion mode restriction.
	 * 
	 * @param diffusionModeRestriction
	 *            the diffusionModeRestriction to set
	 */
	public void setDiffusionModeRestriction(String diffusionModeRestriction) {
		this.diffusionModeRestriction = diffusionModeRestriction;
	}

	/**
	 * Gets the diffusion public vise.
	 * 
	 * @return the diffusionPublicVise
	 */
	public String getDiffusionPublicVise() {
		return diffusionPublicVise;
	}

	/**
	 * Sets the diffusion public vise.
	 * 
	 * @param diffusionPublicVise
	 *            the diffusionPublicVise to set
	 */
	public void setDiffusionPublicVise(String diffusionPublicVise) {
		this.diffusionPublicVise = diffusionPublicVise;
	}

	/**
	 * Gets the diffusion public vise restriction.
	 * 
	 * @return the diffusionPublicViseRestriction
	 */
	public String getDiffusionPublicViseRestriction() {
		return diffusionPublicViseRestriction;
	}

	/**
	 * Sets the diffusion public vise restriction.
	 * 
	 * @param diffusionPublicViseRestriction
	 *            the diffusionPublicViseRestriction to set
	 */
	public void setDiffusionPublicViseRestriction(String diffusionPublicViseRestriction) {
		this.diffusionPublicViseRestriction = diffusionPublicViseRestriction;
	}

	/**
	 * Gets the encadre recherche.
	 * 
	 * @return the encadreRecherche
	 */
	public String getEncadreRecherche() {
		return encadreRecherche;
	}

	/**
	 * Sets the encadre recherche.
	 * 
	 * @param encadreRecherche
	 *            the encadreRecherche to set
	 */
	public void setEncadreRecherche(String encadreRecherche) {
		this.encadreRecherche = encadreRecherche;
	}

	/**
	 * Gets the encadre recherche bis.
	 * 
	 * @return the encadreRechercheBis
	 */
	public String getEncadreRechercheBis() {
		return encadreRechercheBis;
	}

	/**
	 * Sets the encadre recherche bis.
	 * 
	 * @param encadreRechercheBis
	 *            the encadreRechercheBis to set
	 */
	public void setEncadreRechercheBis(String encadreRechercheBis) {
		this.encadreRechercheBis = encadreRechercheBis;
	}

	/**
	 * Gets the etat objet.
	 * 
	 * @return the etatObjet
	 */
	public String getEtatObjet() {
		return etatObjet;
	}

	/**
	 * Sets the etat objet.
	 * 
	 * @param etatObjet
	 *            the etatObjet to set
	 */
	public void setEtatObjet(String etatObjet) {
		this.etatObjet = etatObjet;
	}

	/**
	 * Gets the id pagelibre.
	 * 
	 * @return the idPagelibre
	 */
	public Long getIdPagelibre() {
		return idPagelibre;
	}

	/**
	 * Sets the id pagelibre.
	 * 
	 * @param idPagelibre
	 *            the idPagelibre to set
	 */
	public void setIdPagelibre(Long idPagelibre) {
		this.idPagelibre = idPagelibre;
	}

	/**
	 * Gets the langue.
	 * 
	 * @return the langue
	 */
	public String getLangue() {
		return langue;
	}

	/**
	 * Sets the langue.
	 * 
	 * @param langue
	 *            the langue to set
	 */
	public void setLangue(String langue) {
		this.langue = langue;
	}

	/**
	 * Gets the message alerte.
	 * 
	 * @return the messageAlerte
	 */
	public String getMessageAlerte() {
		return messageAlerte;
	}

	/**
	 * Sets the message alerte.
	 * 
	 * @param messageAlerte
	 *            the messageAlerte to set
	 */
	public void setMessageAlerte(String messageAlerte) {
		this.messageAlerte = messageAlerte;
	}

	/**
	 * Gets the meta description.
	 * 
	 * @return the metaDescription
	 */
	public String getMetaDescription() {
		return metaDescription;
	}

	/**
	 * Sets the meta description.
	 * 
	 * @param metaDescription
	 *            the metaDescription to set
	 */
	public void setMetaDescription(String metaDescription) {
		this.metaDescription = metaDescription;
	}

	/**
	 * Gets the meta keywords.
	 * 
	 * @return the metaKeywords
	 */
	public String getMetaKeywords() {
		return metaKeywords;
	}

	/**
	 * Sets the meta keywords.
	 * 
	 * @param metaKeywords
	 *            the metaKeywords to set
	 */
	public void setMetaKeywords(String metaKeywords) {
		this.metaKeywords = metaKeywords;
	}

	/**
	 * Gets the nb hits.
	 * 
	 * @return the nbHits
	 */
	public Long getNbHits() {
		return nbHits;
	}

	/**
	 * Sets the nb hits.
	 * 
	 * @param nbHits
	 *            the nbHits to set
	 */
	public void setNbHits(Long nbHits) {
		this.nbHits = nbHits;
	}

	/**
	 * Gets the rattachement bandeau.
	 * 
	 * @return the rattachementBandeau
	 */
	public String getRattachementBandeau() {
		return rattachementBandeau;
	}

	/**
	 * Sets the rattachement bandeau.
	 * 
	 * @param rattachementBandeau
	 *            the rattachementBandeau to set
	 */
	public void setRattachementBandeau(String rattachementBandeau) {
		this.rattachementBandeau = rattachementBandeau;
	}

	/**
	 * Gets the titre.
	 * 
	 * @return the titre
	 */
	public String getTitre() {
		return titre;
	}

	/**
	 * Sets the titre.
	 * 
	 * @param titre
	 *            the titre to set
	 */
	public void setTitre(String titre) {
		this.titre = titre;
	}

	/**
	 * Gets the titre encadre.
	 * 
	 * @return the titreEncadre
	 */
	public String getTitreEncadre() {
		return titreEncadre;
	}

	/**
	 * Sets the titre encadre.
	 * 
	 * @param titreEncadre
	 *            the titreEncadre to set
	 */
	public void setTitreEncadre(String titreEncadre) {
		this.titreEncadre = titreEncadre;
	}
}
