/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kdecole.cache.aspect.StaticCacheGet;
import com.kportal.cache.CacheUtil;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosRequeteGroupe;
import com.univ.utils.ContexteDao;

public class CacheGroupeDsiManager {

	public static final String ID_BEAN = "cacheGroupeDsiManager";

	private static final Logger LOGGER = LoggerFactory.getLogger(CacheGroupeDsiManager.class);

	@StaticCacheGet(key = "CacheGroupeDsiManager.getListeGroupesDsi", contextual = false)
	public Map<String, InfosGroupeDsi> getListeGroupesDsi() {
		final Map<String, InfosGroupeDsi> listeGroupesDsi = new HashMap<>();
		final InfosGroupeDsi infosGroupeTop = new InfosGroupeDsi();
		infosGroupeTop.setCode(Groupedsi.CODE_GROUPE_ROOT);
		listeGroupesDsi.put(infosGroupeTop.getCode(), infosGroupeTop);
		try (ContexteDao ctx = new ContexteDao()) {
			final Groupedsi groupe = new Groupedsi();
			groupe.setCtx(ctx);
			groupe.selectNoCount(StringUtils.EMPTY);
			int count = 0;
			while (groupe.nextItem()) {
				final InfosGroupeDsi infosGroupe = new InfosGroupeDsi(groupe);
				listeGroupesDsi.put(infosGroupe.getCode(), infosGroupe);
				count++;
			}
			LOGGER.info("Chargement de " + count + " groupes OK");
		} catch (final Exception e) {
			LOGGER.info("Erreur de chargement des groupes");
		}
		for (final InfosGroupeDsi groupe : listeGroupesDsi.values()) {
			if (!Groupedsi.CODE_GROUPE_ROOT.equals(groupe.getCode())) {
				try {
					InfosGroupeDsi groupePere = listeGroupesDsi.get(groupe.getCodeGroupePere());
					if (groupePere == null || groupePere.getCode().length() == 0) {
						groupePere = infosGroupeTop;
					}
					groupe.rattacheA(groupePere);
				} catch (final Exception e) {
					LOGGER.info("Erreur de rattachement des groupes parents dans le cache");
				}
			}
		}
		return listeGroupesDsi;
	}

	@StaticCacheGet(key = "CacheGroupeDsiManager.getListeRequetesGroupes", contextual = false)
	public Map<String, InfosRequeteGroupe> getListeRequetesGroupes() {
		final Map<String, InfosRequeteGroupe> listeRequetesGroupes = new HashMap<String, InfosRequeteGroupe>();
		for (final IExtension extension : ExtensionHelper.getExtensionManager().getExtensions().values()) {
			final Properties propertiesExtensions = extension.getProperties();
			for (final String nomProp : propertiesExtensions.stringPropertyNames()) {
				if (StringUtils.startsWith(nomProp, "requete_groupe.")) {
					final String[] items = nomProp.split("\\.", -2);
					if (items[2].equals("classe")) {
						final String aliasRequete = items[1];
						final String classe = propertiesExtensions.getProperty(nomProp);
						final String intitule = propertiesExtensions.getProperty("requete_groupe." + aliasRequete + ".intitule");
						String templateJSP = propertiesExtensions.getProperty("requete_groupe." + aliasRequete + ".template_jsp");
						if (StringUtils.isNotBlank(templateJSP)) {
							templateJSP = extension.getRelativePath() + templateJSP;
						}
						final String tsCacheGroupesUtilisateur = propertiesExtensions.getProperty("requete_groupe." + aliasRequete + ".expiration_cache_utilisateur");
						if (tsCacheGroupesUtilisateur != null) {
							listeRequetesGroupes.put(aliasRequete, new InfosRequeteGroupe(aliasRequete, intitule, classe, Long.valueOf(tsCacheGroupesUtilisateur), templateJSP));
						} else {
							listeRequetesGroupes.put(aliasRequete, new InfosRequeteGroupe(aliasRequete, intitule, classe, 0, templateJSP));
						}
					}
				}
			}
		}
		return listeRequetesGroupes;
	}

	public void flush() {
		CacheUtil.flushCache("CacheGroupeDsiManager.getListeGroupesDsi");
		CacheUtil.flushCache("CacheGroupeDsiManager.getListeRequetesGroupes");
	}
}
