/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.cache;

import org.springframework.stereotype.Component;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.cache.AbstractCacheManager;
import com.univ.multisites.service.cache.DonneesInfosSite;

@Component
public class CacheInfosSiteManager extends AbstractCacheManager {

	private static final String ID_BEAN = "cacheInfosSiteManager";

	private static final String KEY_CACHE = "CacheInfosSiteManager.cacheInfosSite";

	public static CacheInfosSiteManager getInstance() {
		return (CacheInfosSiteManager) ApplicationContextManager.getCoreContextBean(ID_BEAN);
	}

	public static DonneesInfosSite getDonneesSites() {
		return getInstance().call();
	}

	@Override
	public DonneesInfosSite getObjectToCache() throws Exception {
		return new DonneesInfosSite();
	}

	@Override
	public String getCacheName() {
		return KEY_CACHE;
	}

	@Override
	public Object getObjectKey() {
		return KEY_CACHE;
	}

	@Override
	public DonneesInfosSite call() {
		return (DonneesInfosSite) super.call();
	}
}
