/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.cache;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kdecole.cache.aspect.StaticCacheFlush;
import com.kdecole.cache.aspect.StaticCacheGet;
import com.univ.objetspartages.om.InfosProfilDsi;
import com.univ.objetspartages.om.Profildsi;
import com.univ.utils.ContexteDao;

public class CacheProfilDsiManager {

	public static final String ID_BEAN = "cacheProfilDsiManager";

	private static final Logger LOGGER = LoggerFactory.getLogger(CacheProfilDsiManager.class);

	@StaticCacheGet(key = "CacheProfilDsiManager.getListeProfilsDsi", contextual = false)
	public Map<String, InfosProfilDsi> getListeProfilsDsi() {
		final ContexteDao ctx = new ContexteDao();
		final Map<String, InfosProfilDsi> listeProfilsDsi = new HashMap<String, InfosProfilDsi>();
		try {
			final Profildsi profil = new Profildsi();
			profil.setCtx(ctx);
			profil.init();
			final int count = profil.select("");
			if (count > 0) {
				while (profil.nextItem()) {
					final InfosProfilDsi infosProfil = new InfosProfilDsi(profil.getCode(), profil.getLibelle(), profil.getCodeRubriqueAccueil(), profil.getRoles(),
						profil.getCodeRattachement(), profil.getVecteurGroupes());
					listeProfilsDsi.put(profil.getCode(), infosProfil);
				}
			}
			LOGGER.info("Chargement de " + count + " profilDsi OK");
		} catch (final Exception e) {
			LOGGER.info("Erreur de chargement des profils DSI", e);
		} finally {
			ctx.close();
		}
		return listeProfilsDsi;
	}

	@StaticCacheFlush(key = "CacheProfilDsiManager.getListeProfilsDsi", contextual = false)
	public void flush() {}
}
