/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.cache;

import java.util.HashMap;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kdecole.cache.aspect.StaticCacheFlush;
import com.kdecole.cache.aspect.StaticCacheGet;
import com.univ.objetspartages.om.InfosRole;
import com.univ.objetspartages.om.Role;
import com.univ.utils.ContexteDao;

public class CacheRoleManager {

	public static final String ID_BEAN = "cacheRoleManager";

	private static final Logger LOGGER = LoggerFactory.getLogger(CacheRoleManager.class);

	@StaticCacheGet(key = "CacheRoleManager.getListeRoles", contextual = false)
	public HashMap<String, InfosRole> getListeRoles() {
		final HashMap<String, InfosRole> listeRoles = new HashMap<>();
		try (ContexteDao ctx = new ContexteDao()) {
			final Role role = new Role();
			role.setCtx(ctx);
			final int count = role.select(StringUtils.EMPTY);
			while (role.nextItem()) {
				final InfosRole infosRole = new InfosRole(role.getCode(), role.getLibelle(), role.getPerimetre(), role.getPermissions());
				listeRoles.put(infosRole.getCode(), infosRole);
			}
			LOGGER.info("Chargement de " + count + " roles OK");
		} catch (final Exception e) {
			LOGGER.info("Erreur de chargement des roles");
		}
		return listeRoles;
	}

	@StaticCacheFlush(key = "CacheRoleManager.getListeRoles", contextual = false)
	public void flush() {}
}
