/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kportal.cache.AbstractCacheManager;
import com.kportal.servlet.ServletContextAwareBean;
import com.univ.objetspartages.om.InfosPreferences;
import com.univ.objetspartages.om.Preferences;
import com.univ.objetspartages.om.Service;
import com.univ.objetspartages.om.ServiceBean;
import com.univ.portail.KportalPortletFragment;
import com.univ.portail.service.registry.PortletDefinitionRegistry;
import com.univ.portail.service.registry.PortletEntityRegistry;
import com.univ.portail.service.registry.PortletOccurenceRegistry;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;

public class CacheServiceManager extends AbstractCacheManager {

	public static final String ID_BEAN = "cacheServiceManager";

	private static final Logger LOGGER = LoggerFactory.getLogger(CacheServiceManager.class);

	public static final String KEY_CACHE = "CacheServiceManager.cacheServices";

	private ServletContextAwareBean servletContextAwareBean;

	private Map<String, ServiceBean> getServices() {
		final Map<String, ServiceBean> services = new HashMap<String, ServiceBean>();
		try (ContexteDao ctx = new ContexteDao()) {
			PortletEntityRegistry.forcerRelecture();
			PortletDefinitionRegistry.forcerRelecture();
			PortletOccurenceRegistry.forcerRelecture();
			LOGGER.debug("fin PortletDefinitionRegistry.forcerRelecture()");
			final Service service = new Service();
			service.setCtx(ctx);
			service.init();
			service.select("ORDER BY ORDRE");
			LOGGER.debug("debut boucle service...");
			while (service.nextItem()) {
				LOGGER.debug("service " + service.getCode() + " " + service.getIntitule());
				final Vector<String> diffusionPublicVise = Chaine.getVecteurAccolades(service.getDiffusionPublicVise());
				final Vector<String> diffusionPublicViseRestriction = Chaine.getVecteurAccolades(service.getDiffusionPublicViseRestriction());
				final Preferences prefGenerales = new Preferences();
				prefGenerales.setCtx(ctx);
				prefGenerales.init();
				final List<InfosPreferences> listePrefs = new ArrayList<InfosPreferences>();
				prefGenerales.selectPreferencesGenerales(service.getCode());
				InfosPreferences infosPreferences = null;
				while (prefGenerales.nextItem()) {
					infosPreferences = new InfosPreferences(prefGenerales);
					listePrefs.add(infosPreferences);
				}
				LOGGER.debug("fin chargement preferences");
				final Integer expirationCacheService = service.getExpirationCache();
				Integer expirationCache = service.getExpirationCache();
				// on charge les préférences de l'entity s'il s'agit d'un service portlet
				if (Service.TYPE_PORTLET.equals(service.getType())) {
					try {
						PortletEntityRegistry.ajouterEntity(service, listePrefs);
						LOGGER.debug("fin chargement entities");
						PortletDefinitionRegistry.ajouterDefinition(servletContextAwareBean.getServletContext(), service);
						LOGGER.debug("fin chargement definitions");
						final KportalPortletFragment fragment = PortletOccurenceRegistry.ajouterFragment(service.getCode());
						if (fragment == null) {
							LOGGER.error("Echec (re)chargement portlet " + service.getIntitule());
						}
						LOGGER.debug("fin chargement fragments");
						if (expirationCache < 0) {
							expirationCache = new Integer(PortletEntityRegistry.getPortletEntity(service.getCode()).getPortletDefinition().getExpirationCache());
						}
						LOGGER.debug("fin chargement cache");
					} catch (final Exception e) {
						LOGGER.error("Echec (re)chargement portlet " + service.getIntitule(), e);
					}
				}
				final ServiceBean serviceBean = new ServiceBean(service.getCode(), service.getIntitule(), service.getType(), service.getEncodage(), expirationCache, expirationCacheService, service.getJetonKportal(), service.getProxyCas(), service.getUrl(), service.getPortletDefinitionId(), service.getUrlPopup(), service.getVueReduiteType(), service.getVueReduiteUrl(), service.getVueReduiteCtx(), service.getVueReduiteUrlCrossCtx(), service.getDiffusionMode(), diffusionPublicVise, service.getDiffusionModeRestriction(), diffusionPublicViseRestriction, listePrefs);
				services.put(service.getCode(), serviceBean);
				LOGGER.debug("fin chargement service " + service.getCode());
			}
			LOGGER.info("Chargement de " + services.size() + " services OK");
		} catch (final Exception e) {
			LOGGER.info("Erreur de chargement des services");
		}
		return services;
	}

	@Override
	public Map<String, ServiceBean> getObjectToCache() throws Exception {
		return getServices();
	}

	@Override
	public String getCacheName() {
		return KEY_CACHE;
	}

	@Override
	public Object getObjectKey() {
		return KEY_CACHE;
	}

	@SuppressWarnings("unchecked")
	@Override
	public Map<String, ServiceBean> call() {
		return (Map<String, ServiceBean>) super.call();
	}

	public void setServletContextAwareBean(final ServletContextAwareBean contextBean) {
		this.servletContextAwareBean = contextBean;
	}
}
