/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.dao;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.datasource.dao.impl.mysql.AbstractCommonDAO;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseOrderBy.SensDeTri;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;

public abstract class AbstractFicheDAO<T> extends AbstractCommonDAO<T> implements FicheDAO<T> {

	@Override
	public List<T> selectParCodeRubrique(String codeRubrique, String langue) throws DataSourceException {
		RequeteSQL codeRubriqueLangueEnLigneOrdreTitre = new RequeteSQL();
		ClauseWhere whereCodeRubriqueLangueEtat = new ClauseWhere();
		if (StringUtils.isNotEmpty(codeRubrique)) {
			whereCodeRubriqueLangueEtat.setPremiereCondition(ConditionHelper.egalVarchar("T1.CODE_RUBRIQUE", codeRubrique));
		}
		if (StringUtils.isNotEmpty(langue)) {
			whereCodeRubriqueLangueEtat.and(ConditionHelper.egalVarchar("T1.LANGUE", langue));
		}
		whereCodeRubriqueLangueEtat.and(ConditionHelper.egalVarchar("T1.ETAT_OBJET", "0003"));
		ClauseOrderBy orderBy = new ClauseOrderBy();
		orderBy.orderBy("T1.TITRE", SensDeTri.ASC);
		codeRubriqueLangueEnLigneOrdreTitre.where(whereCodeRubriqueLangueEtat).orderBy(orderBy);
		return select(codeRubriqueLangueEnLigneOrdreTitre.formaterRequete());
	}

	@Override
	public List<T> selectCodeLangueEtat(String code, String langue, String etat) throws DataSourceException {
		RequeteSQL codeLangueEtatOrdreSurTitre = new RequeteSQL();
		ClauseWhere whereCodeLangueEtat = ConditionHelper.whereCodeLangueEtat(code, langue, etat);
		ClauseOrderBy orderBy = new ClauseOrderBy();
		orderBy.orderBy("T1.TITRE", SensDeTri.ASC);
		codeLangueEtatOrdreSurTitre.where(whereCodeLangueEtat).orderBy(orderBy);
		return select(codeLangueEtatOrdreSurTitre.formaterRequete());
	}
}
