/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.dao;

import java.util.List;

import com.jsbsoft.jtf.datasource.dao.CommonDAO;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;

public interface FicheDAO<T> extends CommonDAO<T>{

	/**
	 * Renvoie la liste des fiches présentes dans la rubrique en paramètre
	 * @param codeRubrique Le code de la rubrique
	 * @param langue La langue demandée
	 * @return Une liste de fiches
	 * @throws DataSourceException
	 */
	public List<T> selectParCodeRubrique(String codeRubrique, String langue) throws DataSourceException;

	/**
	 * Renvoie une fiche à partir de la clé code, langue, état
	 * @param code Le code de la fiche
	 * @param langue La langue de la fiche
	 * @param etat L'état de la fiche
	 * @return Une fiche ou une liste de fiches
	 * @throws DataSourceException
	 */
	public List<T> selectCodeLangueEtat(String code, String langue, String etat) throws DataSourceException;
}
