/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.datasource.dao.CommonDAO;
import com.jsbsoft.jtf.datasource.manager.DataSourceDAOManager;
import com.univ.objetspartages.bean.AbstractPersistenceBean;

public class AbstractOm<T extends AbstractPersistenceBean, Y extends CommonDAO<T>> {

	protected T persistenceBean;

	protected Y commonDao;

	protected Collection<T> currentSelect;

	protected Iterator<T> currentSelectIt;

	private static final Logger LOG = LoggerFactory.getLogger(AbstractOm.class);

	@SuppressWarnings("unchecked")
	private Class<T> getGenericType() {
		return (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
	}

	@SuppressWarnings("unchecked")
	public AbstractOm() {
		final DataSourceDAOManager manager = (DataSourceDAOManager) ApplicationContextManager.getCoreContextBean(DataSourceDAOManager.ID_BEAN);
		commonDao = (Y) manager.getDao(getGenericType());
		try {
			persistenceBean = getGenericType().newInstance();
		} catch (InstantiationException | IllegalAccessException e) {
			LOG.error(String.format("Couldn't instanciate %s object", getGenericType().getName()), e);
		}
	}

	public T getPersistenceBean() {
		return persistenceBean;
	}

	public void setPersistenceBean(final T persistenceBean) {
		this.persistenceBean = persistenceBean;
	}

	public void add() throws Exception {
		commonDao.add(persistenceBean);
	}

	public void delete() throws Exception {
		commonDao.delete(persistenceBean.getId());
	}

	public void update() throws Exception {
		commonDao.update(persistenceBean);
	}

	public T getById(final Long id) throws Exception {
		return commonDao.getById(id);
	}

	public int select(final String requete) throws Exception {
		currentSelect = commonDao.select(requete);
		currentSelectIt = currentSelect.iterator();
		return currentSelect.size();
	}

	public List<T> selectAll(final String requete) throws Exception {
		return commonDao.select(requete);
	}

	@Deprecated
	public boolean nextItem() throws Exception {
		if (currentSelectIt != null && currentSelectIt.hasNext()) {
			persistenceBean = currentSelectIt.next();
			return true;
		}
		return false;
	}
}
