/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

/**
 * Fiche à diffusion sélective.
 */
public interface DiffusionSelective {

	/**
	 * Insérez la description de la méthode à cet endroit. Date de création : (10/01/2003 14:52:43)
	 * 
	 * @return java.lang.String
	 */
	public String getDiffusionModeRestriction();

	/**
	 * Gets the diffusion public vise.
	 * 
	 * @return the diffusion public vise
	 */
	public String getDiffusionPublicVise();

	/**
	 * Gets the diffusion public vise restriction.
	 * 
	 * @return the diffusion public vise restriction
	 */
	public String getDiffusionPublicViseRestriction();

	/**
	 * Sets the diffusion mode restriction.
	 * 
	 * @param _diffusionModeRestriction
	 *            the new diffusion mode restriction
	 */
	public void setDiffusionModeRestriction(String _diffusionModeRestriction);

	/**
	 * Sets the diffusion public vise.
	 * 
	 * @param _diffusionPublicVise
	 *            the new diffusion public vise
	 */
	public void setDiffusionPublicVise(String _diffusionPublicVise);

	/**
	 * Sets the diffusion public vise restriction.
	 * 
	 * @param _diffusionPublicViseRestriction
	 *            the new diffusion public vise restriction
	 */
	public void setDiffusionPublicViseRestriction(String _diffusionPublicViseRestriction);
}