/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;


public enum EtatFiche {

	BROUILLON("0001", true), A_VALIDER("0002",true), EN_LIGNE("0003", true), A_SUPPRIMER("0004", false), APERCU("0005", false), SAUVEGARDE_AUTO("0006", false), ARCHIVE("0007", false);

	private String etat;

	private boolean isFront;

	private EtatFiche(String codeEtat, boolean isVisibleInFront) {
		etat = codeEtat;
		isFront = isVisibleInFront;
	}

	public String getEtat() {
		return etat;
	}

	@Override
	public String toString() {
		return etat;
	}

	public static EtatFiche getEtatParCode(String code) {
		for (EtatFiche etatFiche : values()) {
			if (etatFiche.getEtat().equals(code)) {
				return etatFiche;
			}
		}
		return null;
	}

	/**
	 * Vérifie que l'état passé en paramètre correspond à un état dit "stable" A_SUPPRIMER va être supprimer par le scansite APERCU est un état temporaire uniquement dispo lors de
	 * l'apercu et supprimé tout de suite après SAUVEGARDE_AUTO n'est dispo qu'en édition et une fois la fiche sauvegarder il disparait
	 * 
	 * @param code le code de l"état à vérifier
	 * @return vrai si l'état est un état "stable" (ni sauvegarde auto, ni a supprimer, ni apercu, ni brouillon)
	 */
	public static boolean isEtatPerene(String code) {
		EtatFiche etatCourant = EtatFiche.getEtatParCode(code);
		return isEtatPerene(etatCourant);
	}

	/**
	 * Vérifie que l'état passé en paramètre correspond à un état dit "stable" A_SUPPRIMER va être supprimer par le scansite APERCU est un état temporaire uniquement dispo lors de
	 * l'apercu et supprimé tout de suite après SAUVEGARDE_AUTO n'est dispo qu'en édition et une fois la fiche sauvegarder il disparait
	 *
	 * @param etat "état à vérifier
	 * @return vrai si l'état est un état "stable" (ni sauvegarde auto, ni a supprimer, ni apercu, ni brouillon)
	 */
	public static boolean isEtatPerene(EtatFiche etat) {
		return BROUILLON.equals(etat) || A_VALIDER.equals(etat) || EN_LIGNE.equals(etat) || ARCHIVE.equals(etat);
	}

	public static boolean isAValider(String code) {
		EtatFiche etatCourant = EtatFiche.getEtatParCode(code);
		return A_VALIDER.equals(etatCourant);
	}

	public static boolean isEtatEnregistrable(String code) {
		EtatFiche etatCourant = EtatFiche.getEtatParCode(code);
		return !A_VALIDER.equals(etatCourant) && !SAUVEGARDE_AUTO.equals(etatCourant) && !A_SUPPRIMER.equals(etatCourant);
	}

	public boolean isFront() {
		return isFront;
	}
}
