/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.utils.EscapeString;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;

public class FicheObjetHelper {

	/**
	 * Methode d'update global d'une arborescence de commentaire en fonction de la fiche parente principale
	 * 
	 * @param ctx
	 *            the _ctx
	 * @param ficheUniv
	 *            the _fiche univ
	 * @param idMeta
	 *            'id du metatag de la fiche parente
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public static void updateAll(final OMContext ctx, final FicheUniv ficheUniv, final String classeObjet, final Long idMeta) throws Exception {
		final String codeObjet = ReferentielObjets.getCodeObjetParClasse(classeObjet);
		final FicheUniv ficheObjet = ReferentielObjets.instancierFiche(codeObjet);
		if (ficheObjet instanceof FicheObjet) {
			final String codeRattachement = ficheUniv.getCodeRattachement();
			final String codeRubrique = ficheUniv.getCodeRubrique();
			String codeRattachementAutres = "";
			if (ficheUniv instanceof FicheRattachementsSecondaires) {
				codeRattachementAutres = ((FicheRattachementsSecondaires) ficheUniv).getCodeRattachementAutres();
			}
			String publicVise = "";
			String publicModeRestriction = "";
			String publicViseRestriction = "";
			if (ficheUniv instanceof DiffusionSelective) {
				publicVise = ((DiffusionSelective) ficheUniv).getDiffusionPublicVise();
				publicModeRestriction = ((DiffusionSelective) ficheUniv).getDiffusionModeRestriction();
				publicViseRestriction = ((DiffusionSelective) ficheUniv).getDiffusionPublicViseRestriction();
			}
			final String etatObjet = ficheUniv.getEtatObjet();
			java.sql.PreparedStatement _stmt = null;
			try {
				final ClauseWhere whereIdMeta = new ClauseWhere(ConditionHelper.egal("ID_META", idMeta, TypeOperande.LONG));
				String query = "SELECT ID_" + ReferentielObjets.getNomTableSql(codeObjet) + " FROM " + ReferentielObjets.getNomTableSql(codeObjet) + whereIdMeta.formaterSQL();
				_stmt = ctx.getConnection().prepareStatement(query);
				final ResultSet rs = _stmt.executeQuery();
				final Collection<String> idsMeta = new ArrayList<String>();
				while (rs.next()) {
					idsMeta.add(EscapeString.escapeSqlValue(String.valueOf(rs.getLong(1))));
				}
				rs.close();
				if (CollectionUtils.isNotEmpty(idsMeta)) {
					// update de la table objet
					query = "UPDATE " + ReferentielObjets.getNomTableSql(codeObjet) + " SET " + "ETAT_OBJET='" + EscapeString.escapeSqlValue(etatObjet) + "', " + "CODE_RUBRIQUE='" + EscapeString.escapeSql(codeRubrique) + "', " + "CODE_RATTACHEMENT='" + EscapeString.escapeSqlValue(codeRattachement) + "', " + "CODE_RATTACHEMENT_AUTRES='" + EscapeString.escapeSqlValue(codeRattachementAutres) + "', " + "DIFFUSION_PUBLIC_VISE='" + EscapeString.escapeSqlValue(publicVise) + "'," + "DIFFUSION_MODE_RESTRICTION='" + EscapeString.escapeSqlValue(publicModeRestriction) + "', " + "DIFFUSION_PUBLIC_VISE_RESTRICTION='" + EscapeString.escapeSqlValue(publicViseRestriction) + "', " + "DATE_MODIFICATION='" + ficheUniv.getDateModification() + "' " + " WHERE ID_" + ReferentielObjets.getNomTableSql(codeObjet) + " IN (" + StringUtils.join(
						idsMeta, " , ") + " ) ";
					_stmt.close();
					_stmt = ctx.getConnection().prepareStatement(query);
					_stmt.executeUpdate();
					// update de la table meta
					query = "UPDATE METATAG SET META_ETAT_OBJET='" + EscapeString.escapeSqlValue(etatObjet) + "', " + "META_CODE_RUBRIQUE='" + EscapeString.escapeSqlValue(codeRubrique) + "', " + "META_CODE_RATTACHEMENT='" + EscapeString.escapeSqlValue(codeRattachement) + "', " + "META_CODE_RATTACHEMENT_AUTRES='" + EscapeString.escapeSqlValue(codeRattachementAutres) + "', " + "META_DIFFUSION_PUBLIC_VISE='" + EscapeString.escapeSqlValue(publicVise) + "'," + "META_DIFFUSION_MODE_RESTRICTION='" + EscapeString.escapeSqlValue(publicModeRestriction) + "', META_DIFFUSION_PUBLIC_VISE_RESTRICTION='" + EscapeString.escapeSqlValue(publicViseRestriction) + "',  META_DATE_MODIFICATION='" + ficheUniv.getDateModification() + "' WHERE META_ID_FICHE IN (" + StringUtils.join(
						idsMeta, " , ") + ") AND META_CODE_OBJET='" + EscapeString.escapeSqlValue(codeObjet) + "'";
					_stmt.close();
					_stmt = ctx.getConnection().prepareStatement(query);
					_stmt.executeUpdate();
					_stmt.close();
				}
			} catch (final SQLException exc) {
				throw new Exception("ERROR_IN_METHOD FicheNonLisibleHelper.updateGlobal() " + exc);
			} finally {
				if (_stmt != null) {
					_stmt.close();
				}
			}
		}
	}

	/**
	 * Methode de suppression globale d'une arborescence de commentaires
	 * 
	 * @param ctx le contexte uniquement pour la request
	 * @param classeObjet la classe de l'objet
	 * @param idMeta lid du metatag de la fiche parente
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public static void deleteAll(final OMContext ctx, final String classeObjet, final Long idMeta) throws Exception {
		final String codeObjet = ReferentielObjets.getCodeObjetParClasse(classeObjet);
		final FicheUniv ficheUniv = ReferentielObjets.instancierFiche(codeObjet);
		if (ficheUniv instanceof FicheObjet) {
			java.sql.PreparedStatement _stmt = null;
			try {
				final ClauseWhere whereIdMeta = new ClauseWhere(ConditionHelper.egal("ID_META", idMeta, TypeOperande.LONG));
				String query = "SELECT ID_" + ReferentielObjets.getNomTableSql(codeObjet) + " FROM " + ReferentielObjets.getNomTableSql(codeObjet) + whereIdMeta.formaterSQL();
				_stmt = ctx.getConnection().prepareStatement(query);
				final ResultSet rs = _stmt.executeQuery();
				final Collection<String> idsMeta = new ArrayList<String>();
				while (rs.next()) {
					idsMeta.add(String.valueOf(rs.getLong(1)));
				}
				rs.close();
				if (CollectionUtils.isNotEmpty(idsMeta)) {
					// suppression de la table objet
					final ClauseWhere whereIdMetaIn = new ClauseWhere(ConditionHelper.in("ID_" + ReferentielObjets.getNomTableSql(codeObjet), idsMeta));
					query = "DELETE FROM " + ReferentielObjets.getNomTableSql(codeObjet) + whereIdMetaIn.formaterSQL();
					_stmt = ctx.getConnection().prepareStatement(query);
					_stmt.executeUpdate();
					//suppression de la table meta
					final ClauseWhere whereIdMetaInAndCodeObjet = new ClauseWhere(ConditionHelper.in("META_ID_FICHE", idsMeta));
					whereIdMetaInAndCodeObjet.and(ConditionHelper.egalVarchar("META_CODE_OBJET", codeObjet));
					query = "DELETE FROM METATAG " + whereIdMetaInAndCodeObjet.formaterSQL();
					_stmt = ctx.getConnection().prepareStatement(query);
					_stmt.executeUpdate();
				}
				_stmt.close();
			} catch (final SQLException exc) {
				throw new Exception("ERROR_IN_METHOD FicheNonLisibleHelper.deleteGlobal() " + exc);
			} finally {
				_stmt = null;
			}
		}
	}
}
