/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.sql.Date;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.sgbd.FicheUnivDB;

/**
 * Interface décrivant une fiche K-Portal.
 */
public interface FicheUniv extends FicheUnivDB {

	/**
	 * Inits the.
	 */
	public void init();

	/**
	 * Gets the id fiche.
	 *
	 * @return the id fiche
	 */
	public Long getIdFiche();

	/**
	 * Sets the id fiche.
	 *
	 * @param idFiche
	 *            the new id fiche
	 */
	public void setIdFiche(Long idFiche);

	/**
	 * Gets the code rubrique.
	 *
	 * @return the code rubrique
	 */
	public String getCodeRubrique();

	/**
	 * Sets the code rubrique.
	 *
	 * @param codeRubrique
	 *            the new code rubrique
	 */
	public void setCodeRubrique(String codeRubrique);

	/* (non-Javadoc)
	 * @see com.univ.objetspartages.om.MultiLangue#getCode()
	 */
	/**
	 * Gets the code.
	 *
	 * @return the code
	 */
	public String getCode();

	/* (non-Javadoc)
	 * @see com.univ.objetspartages.om.MultiLangue#getLangue()
	 */
	/**
	 * Gets the langue.
	 *
	 * @return the langue
	 */
	public String getLangue();

	/**
	 * Gets the code redacteur.
	 *
	 * @return the code redacteur
	 */
	public String getCodeRedacteur();

	/**
	 * Gets the code validation.
	 *
	 * @return the code validation
	 */
	public String getCodeValidation();

	/**
	 * Gets the code rattachement.
	 *
	 * @return the code rattachement
	 */
	public String getCodeRattachement();

	/**
	 * Gets the etat objet.
	 *
	 * @return the etat objet
	 */
	public String getEtatObjet();

	/**
	 * Gets the message alerte.
	 *
	 * @return the message alerte
	 */
	public String getMessageAlerte();

	/**
	 * Gets the meta keywords.
	 *
	 * @return the meta keywords
	 */
	public String getMetaKeywords();

	/**
	 * Gets the meta description.
	 *
	 * @return the meta description
	 */
	public String getMetaDescription();

	/**
	 * Gets the titre encadre.
	 *
	 * @return the titre encadre
	 */
	public String getTitreEncadre();

	/**
	 * Gets the contenu encadre.
	 *
	 * @return the contenu encadre
	 */
	public String getContenuEncadre();

	/**
	 * Gets the encadre recherche.
	 *
	 * @return the encadre recherche
	 */
	public String getEncadreRecherche();

	/**
	 * Gets the encadre recherche bis.
	 *
	 * @return the encadre recherche bis
	 */
	public String getEncadreRechercheBis();

	/**
	 * Gets the date alerte.
	 *
	 * @return the date alerte
	 */
	public Date getDateAlerte();

	/**
	 * Gets the date creation.
	 *
	 * @return the date creation
	 */
	public Date getDateCreation();

	/**
	 * Gets the date modification.
	 *
	 * @return the date modification
	 */
	public Date getDateModification();

	/**
	 * Gets the date proposition.
	 *
	 * @return the date proposition
	 */
	public Date getDateProposition();

	/**
	 * Gets the date validation.
	 *
	 * @return the date validation
	 */
	public Date getDateValidation();

	/**
	 * Gets the nb hits.
	 *
	 * @return the nb hits
	 */
	public Long getNbHits();

	/* (non-Javadoc)
	 * @see com.univ.objetspartages.om.MultiLangue#setCode(java.lang.String)
	 */
	/**
	 * Sets the code.
	 *
	 * @param code
	 *            the new code
	 */
	public void setCode(String code);

	/* (non-Javadoc)
	 * @see com.univ.objetspartages.om.MultiLangue#setLangue(java.lang.String)
	 */
	/**
	 * Sets the langue.
	 *
	 * @param langue
	 *            the new langue
	 */
	public void setLangue(String langue);

	/**
	 * Sets the ctx.
	 *
	 * @param ctx
	 *            the new ctx
	 */
	public void setCtx(OMContext ctx);

	/**
	 * Sets the code redacteur.
	 *
	 * @param codeRedacteur
	 *            the new code redacteur
	 */
	public void setCodeRedacteur(String codeRedacteur);

	/**
	 * Sets the code validation.
	 *
	 * @param codeValidation
	 *            the new code validation
	 */
	public void setCodeValidation(String codeValidation);

	/**
	 * Sets the code rattachement.
	 *
	 * @param codeRattachement
	 *            the new code rattachement
	 */
	public void setCodeRattachement(String codeRattachement);

	/**
	 * Sets the etat objet.
	 *
	 * @param etatObjet
	 *            the new etat objet
	 */
	public void setEtatObjet(String etatObjet);

	/**
	 * Sets the message alerte.
	 *
	 * @param messageAlerte
	 *            the new message alerte
	 */
	public void setMessageAlerte(String messageAlerte);

	/**
	 * Sets the meta keywords.
	 *
	 * @param metaKeywords
	 *            the new meta keywords
	 */
	public void setMetaKeywords(String metaKeywords);

	/**
	 * Sets the meta description.
	 *
	 * @param metaDescription
	 *            the new meta description
	 */
	public void setMetaDescription(String metaDescription);

	/**
	 * Sets the titre encadre.
	 *
	 * @param titreEncadre
	 *            the new titre encadre
	 */
	public void setTitreEncadre(String titreEncadre);

	/**
	 * Sets the contenu encadre.
	 *
	 * @param contenuEncadre
	 *            the new contenu encadre
	 */
	public void setContenuEncadre(String contenuEncadre);

	/**
	 * Sets the encadre recherche.
	 *
	 * @param encadreRecherche
	 *            the new encadre recherche
	 */
	public void setEncadreRecherche(String encadreRecherche);

	/**
	 * Sets the encadre recherche bis.
	 *
	 * @param encadreRecherche
	 *            the new encadre recherche bis
	 */
	public void setEncadreRechercheBis(String encadreRecherche);

	/**
	 * Sets the date alerte.
	 *
	 * @param dateAlerte
	 *            the new date alerte
	 */
	public void setDateAlerte(Date dateAlerte);

	/**
	 * Sets the date creation.
	 *
	 * @param dateCreation
	 *            the new date creation
	 */
	public void setDateCreation(Date dateCreation);

	/**
	 * Sets the date modification.
	 *
	 * @param dateCreation
	 *            the new date modification
	 */
	public void setDateModification(Date dateCreation);

	/**
	 * Sets the date proposition.
	 *
	 * @param dateProposition
	 *            the new date proposition
	 */
	public void setDateProposition(Date dateProposition);

	/**
	 * Sets the date validation.
	 *
	 * @param dateValidation
	 *            the new date validation
	 */
	public void setDateValidation(Date dateValidation);

	/**
	 * Sets the nb hits.
	 *
	 * @param nbHits
	 *            the new nb hits
	 */
	public void setNbHits(Long nbHits);

	/**
	 * Gets the libelle affichable.
	 *
	 * @return the libelle affichable
	 *
	 * @throws Exception
	 *             the exception
	 */
	public String getLibelleAffichable();

	/**
	 * Gets the full text string.
	 *
	 * @return the full text string
	 *
	 * @throws Exception
	 *             the exception
	 */
	public String getFullTextString() throws Exception;

	/**
	 * Gets the references.
	 *
	 * @return the references
	 */
	public String getReferences();

	/* (non-Javadoc)
	 * @see com.univ.objetspartages.om.MultiLangue#dupliquer(java.lang.String)
	 */
	/**
	 * Dupliquer.
	 *
	 * @param nouvelleLangue
	 *            the nouvelle langue
	 *
	 * @throws Exception
	 *             the exception
	 */
	public void dupliquer(String nouvelleLangue) throws Exception;

	/* (non-Javadoc)
	 * @see com.univ.objetspartages.om.MultiLangue#selectCodeLangueEtat(java.lang.String, java.lang.String, java.lang.String)
	 */
	/**
	 * Select code langue etat.
	 *
	 * @param code
	 *            the code
	 * @param langue
	 *            the langue
	 * @param etat
	 *            the etat
	 *
	 * @return the int
	 *
	 * @throws Exception
	 *             the exception
	 */
	public int selectCodeLangueEtat(String code, String langue, String etat) throws Exception;

	/**
	 * Traiter requete.
	 *
	 * @param requete the requete
	 * @return the int
	 * @throws Exception the exception
	 */
	public int traiterRequete(String requete) throws Exception;

	/**
	 * Select par code rubrique.
	 *
	 * @param codeRubrique the code rubrique
	 * @param langue the langue
	 * @return the int
	 * @throws Exception the exception
	 */
	public int selectParCodeRubrique(String codeRubrique, String langue) throws Exception;
}
