/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.sql.Date;

// TODO: Auto-generated Javadoc
/**
 * Interface definissant les accès sur un objet mappé avec un utilisateur. Elle est notamment utilisée pour la synchronisation des objets métier avec un utilisateur.
 * 
 * @author jbiard
 * @see com.univ.utils.ISynchroniseurUtilisateurMetier
 */
public interface IUtilisateurMapping {

	/**
	 * Gets the code.
	 * 
	 * @return the code
	 */
	String getCode();

	/**
	 * Sets the code.
	 * 
	 * @param codeUtilisateur
	 *            the new code
	 */
	void setCode(String codeUtilisateur);

	/**
	 * Gets the nom.
	 * 
	 * @return the nom
	 */
	String getNom();

	/**
	 * Sets the nom.
	 * 
	 * @param nom
	 *            the new nom
	 */
	void setNom(String nom);

	/**
	 * Gets the prenom.
	 * 
	 * @return the prenom
	 */
	String getPrenom();

	/**
	 * Sets the prenom.
	 * 
	 * @param prenom
	 *            the new prenom
	 */
	void setPrenom(String prenom);

	/**
	 * Gets the adresse mail.
	 * 
	 * @return the adresse mail
	 */
	String getAdresseMail();

	/**
	 * Sets the adresse mail.
	 * 
	 * @param adresseMail
	 *            the new adresse mail
	 */
	void setAdresseMail(String adresseMail);

	/**
	 * Gets the civilite.
	 * 
	 * @return the civilite
	 */
	String getCivilite();

	/**
	 * Sets the civilite.
	 * 
	 * @param civilite
	 *            the new civilite
	 */
	void setCivilite(String civilite);

	/**
	 * Gets the login.
	 * 
	 * @return the login
	 */
	String getLogin();

	/**
	 * Sets the login.
	 * 
	 * @param login
	 *            the new login
	 */
	void setLogin(String login);

	/**
	 * Gets the date naissance.
	 * 
	 * @return the date naissance
	 */
	Date getDateNaissance();

	/**
	 * Sets the date naissance.
	 * 
	 * @param date
	 *            the new date naissance
	 */
	void setDateNaissance(Date date);

	/**
	 * Gets the code rattachement.
	 * 
	 * @return the code rattachement
	 */
	String getCodeRattachement();

	/**
	 * Sets the code rattachement.
	 * 
	 * @param codeRattachement
	 *            the new code rattachement
	 */
	void setCodeRattachement(String codeRattachement);

	// definis la source import de l'utilisateur, cad la provennance lors de l'import
	/**
	 * Sets the source import utilisateur.
	 * 
	 * @param sourceImportUtilisateur
	 *            the new source import utilisateur
	 */
	void setSourceImportUtilisateur(String sourceImportUtilisateur);

	/**
	 * Gets the source import utilisateur.
	 * 
	 * @return the source import utilisateur
	 */
	String getSourceImportUtilisateur();
}
