/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 23 août 2006
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 *
 */
package com.univ.objetspartages.om;

// TODO: Auto-generated Javadoc

import java.io.Serializable;

/**
 * The Class InfosLibelle.
 */
public class InfosLibelle implements Serializable {

	private static final long serialVersionUID = -6923376035543645551L;

	/** The id libelle. */
	private Long idLibelle = new Long(0);

	/** The type. */
	private String type = "";

	/** The code. */
	private String code = "";

	/** The libelle. */
	private String libelle = "";

	/** The langue. */
	private String langue = "";

	/**
	 * Constructeur.
	 * 
	 * @param libelle
	 *            le libelle à partir duquel on construit l'objet InfosLibelle
	 */
	public InfosLibelle(Libelle libelle) {
		this.idLibelle = libelle.getIdLibelle();
		this.type = libelle.getType();
		this.code = libelle.getCode();
		this.libelle = libelle.getLibelle();
		this.langue = libelle.getLangue();
	}

	/**
	 * Gets the code.
	 * 
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * Gets the id libelle.
	 * 
	 * @return the id libelle
	 */
	public Long getIdLibelle() {
		return idLibelle;
	}

	/**
	 * Gets the langue.
	 * 
	 * @return the langue
	 */
	public String getLangue() {
		return langue;
	}

	/**
	 * Gets the libelle.
	 * 
	 * @return the libelle
	 */
	public String getLibelle() {
		return libelle;
	}

	/**
	 * Gets the type.
	 * 
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	public String getLibelleAffichable() {
		try {
			if (getLibelle().startsWith("[")) {
				int i = getLibelle().indexOf("]") + 1;
				if (i != 0 && i != getLibelle().length()) {
					return getLibelle().substring(i);
				}
			}
		} catch (Exception e) {}
		return getLibelle();
	}
}
