/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

// TODO: Auto-generated Javadoc
/**
 * The Class InfosPreferences.
 */
public class InfosPreferences {

	/** The code utilisateur. */
	private String codeUtilisateur = "";

	/** The service. */
	private String service = "";

	/** The type. */
	private String type = "";

	/** The nom. */
	private String nom = "";

	/** The valeur. */
	private List<String> valeur = new ArrayList<String>();

	/**
	 * Instantiates a new infos preferences.
	 * 
	 * @param pref
	 *            the pref
	 */
	public InfosPreferences(final Preferences pref) {
		super();
		if (pref != null) {
			this.codeUtilisateur = pref.getCodeUtilisateur();
			this.service = pref.getService();
			this.type = pref.getType();
			this.nom = pref.getNom();
			this.valeur = Preferences.getListeValeurPreference(pref.getValeur());
		}
	}

	/**
	 * Instantiates a new infos preferences.
	 * 
	 * @param codeUtilisateur
	 *            the code utilisateur
	 * @param service
	 *            the service
	 * @param type
	 *            the type
	 * @param nom
	 *            the nom
	 * @param valeur
	 *            the valeur
	 */
	public InfosPreferences(final String codeUtilisateur, final String service, final String type, final String nom, final String valeur) {
		super();
		this.codeUtilisateur = codeUtilisateur;
		this.service = service;
		this.type = type;
		this.nom = nom;
		this.valeur = Preferences.getListeValeurPreference(valeur);
	}

	/**
	 * Gets the code utilisateur.
	 * 
	 * @return the code utilisateur
	 */
	public String getCodeUtilisateur() {
		return codeUtilisateur;
	}

	/**
	 * Gets the nom.
	 * 
	 * @return the nom
	 */
	public String getNom() {
		return nom;
	}

	/**
	 * Gets the service.
	 * 
	 * @return the service
	 */
	public String getService() {
		return service;
	}

	/**
	 * Gets the type.
	 * 
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	//    public String[] getValeurs() {
	//        String[] obj = new String[valeur.size()];
	//        return (String[]) valeur.toArray(obj);
	//    }
	/**
	 * Gets the valeurs as list.
	 * 
	 * @return the valeurs as list
	 */
	public List<String> getValeursAsList() {
		//public String getValeur() {
		return valeur;
	}

	/**
	 * Méthode permettant d'affecter les valeurs contenues dans la liste.
	 * 
	 * @return the valeurs as string
	 */
	public String getValeursAsString() {
		String value = "";
		final Iterator<String> itValues = valeur.iterator();
		while (itValues.hasNext()) {
			String val = itValues.next();
			val = val.replaceAll(";", ";;");
			if ("".equals(value)) {
				value = val;
			} else {
				value = value.concat(";".concat(val));
			}
		}
		return value;
	}

	/**
	 * Sets the valeur.
	 * 
	 * @param itValeurAInserer
	 *            the new valeur
	 */
	public void setValeur(final Iterator<String> itValeurAInserer) {
		valeur.clear();
		if (itValeurAInserer != null) {
			while (itValeurAInserer.hasNext()) {
				valeur.add(itValeurAInserer.next());
			}
		}
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		boolean equals = false;
		if (obj instanceof InfosPreferences) {
			equals = this.nom.equals(((InfosPreferences) obj).getNom());
		}
		return equals;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return this.nom.hashCode();
	}
}
