/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.io.Serializable;
import java.util.Vector;

/**
 * Informations stockées en mémoire pour un profil DSI.
 */
public class InfosProfilDsi implements Serializable {

	private static final long serialVersionUID = 3823057122979029072L;

	/** The code. */
	private String code = "";

	/** The intitule. */
	private String intitule = "";

	/** The roles. */
	private String roles = "";

	/** The code rattachement. */
	private String codeRattachement = "";

	/** The groupes. */
	private Vector<String> groupes = new Vector<String>();

	/** The code page accueil. */
	private String codeRubriqueAccueil = "";

	/**
	 * Constructeur InfosGroupeDSI.
	 */
	public InfosProfilDsi() {}

	/**
	 * Commentaire relatif au constructeur InfosGroupeDSI.
	 * 
	 * @param _code
	 *            the _code
	 * @param _intitule
	 *            the _intitule
	 * @param _codePageAccueil
	 *            the _code page accueil
	 * @param _roles
	 *            the _roles
	 * @param _codeRattachement
	 *            the _code rattachement
	 * @param _groupes
	 *            the _groupes
	 */
	public InfosProfilDsi(String _code, String _intitule, String _codePageAccueil, String _roles, String _codeRattachement, Vector<String> _groupes) {
		code = _code;
		intitule = _intitule;
		codeRubriqueAccueil = _codePageAccueil;
		roles = _roles;
		groupes = _groupes;
		codeRattachement = _codeRattachement;
	}

	/**
	 * Gets the groupes.
	 * 
	 * @return Returns the groupes.
	 */
	public Vector<String> getGroupes() {
		return groupes;
	}

	/**
	 * Gets the code.
	 * 
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * Gets the intitule.
	 * 
	 * @return the intitule
	 */
	public String getIntitule() {
		return intitule;
	}

	/**
	 * Gets the code page accueil.
	 * 
	 * @return the code page accueil
	 */
	public String getCodeRubriqueAccueil() {
		return codeRubriqueAccueil;
	}

	/**
	 * Gets the code rattachement.
	 * 
	 * @return the code rattachement
	 */
	public String getCodeRattachement() {
		return codeRattachement;
	}

	/**
	 * Gets the roles.
	 * 
	 * @return Returns the roles.
	 */
	public String getRoles() {
		return roles;
	}
}
