/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * The Class InfosRole.
 *
 * @author jean-sébastien steux
 *
 *         Stockage des rôles en mémoire
 */
public class InfosRole implements Serializable {

	private static final long serialVersionUID = -2046051297628723043L;

	/** The code. */
	private String code = "";

	/** The intitule. */
	private String intitule = "";

	/** The permissions. */
	private String permissions = "";

	/** The perimetre. */
	private String perimetre = "";

	/** The v permissions. */
	private Vector<PermissionBean> vPermissions = null;

	/**
	 * Constructeur vide.
	 */
	public InfosRole() {
		calculerVecteurPermissions();
	}

	/**
	 * The Constructor.
	 *
	 * @param code
	 *            the code
	 * @param intitule
	 *            the intitule
	 * @param permissions
	 *            the permissions
	 * @param perimetre
	 *            the perimetre
	 */
	public InfosRole(final String code, final String intitule, final String perimetre, final String permissions) {
		this.code = code;
		this.intitule = intitule;
		this.permissions = permissions;
		this.perimetre = perimetre;
		calculerVecteurPermissions();
	}

	/**
	 * Gets the code.
	 *
	 * @return Returns the code.
	 */
	public String getCode() {
		return code;
	}

	/**
	 * Sets the code.
	 *
	 * @param code
	 *            The code to set.
	 */
	public void setCode(final String code) {
		this.code = code;
	}

	/**
	 * Gets the intitule.
	 *
	 * @return Returns the intitule.
	 */
	public String getIntitule() {
		return intitule;
	}

	/**
	 * Sets the intitule.
	 *
	 * @param intitule
	 *            The intitule to set.
	 */
	public void setIntitule(final String intitule) {
		this.intitule = intitule;
	}

	/**
	 * Gets the perimetre.
	 *
	 * @return Returns the perimetre.
	 */
	public String getPerimetre() {
		return perimetre;
	}

	/**
	 * Sets the perimetre.
	 *
	 * @param perimetre
	 *            The perimetre to set.
	 */
	public void setPerimetre(final String perimetre) {
		this.perimetre = perimetre;
	}

	/**
	 * Gets the permissions.
	 *
	 * @return Returns the permissions.
	 */
	public String getPermissions() {
		return permissions;
	}

	/**
	 * Sets the permissions.
	 *
	 * @param permissions
	 *            The permissions to set.
	 */
	public void setPermissions(final String permissions) {
		this.permissions = permissions;
	}

	/**
	 * Renvoie la liste des permissions sous forme de vecteur.
	 *
	 * @return Returns the vPermissions.
	 */
	public Vector<PermissionBean> getVecteurPermissions() {
		return vPermissions;
	}

	/**
	 * Calculer vecteur permissions.
	 */
	private void calculerVecteurPermissions() {
		vPermissions = new Vector<PermissionBean>();
		final StringTokenizer st = new StringTokenizer(getPermissions(), "[]");
		while (st.hasMoreTokens()) {
			vPermissions.add(new PermissionBean(st.nextToken()));
		}
	}
}
