/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 9 nov. 07
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.univ.objetspartages.om;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.upload.UploadedFile;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.univ.mediatheque.Mediatheque;
import com.univ.mediatheque.utils.MediathequeHelper;
import com.univ.utils.FileUtil;
import com.univ.utils.ImageInfo;
import com.univ.utils.PhotoUtil;

public class MediaPhoto extends SpecificMedia {

    /** The critere limite. */
    private static CriterePhoto critereLimite = null;

    /** The critere vignette. */
    private static CriterePhoto critereVignette = null;

    /** The lst critere photo. */
    private static ArrayList<Object> lstCriterePhoto = null;

    /** The lst critere ATTRIBUT_LARGEUR. */
    public static final String ATTRIBUT_LARGEUR = "LARGEUR";

    /** The lst critere ATTRIBUT_HAUTEUR. */
    public static final String ATTRIBUT_HAUTEUR = "HAUTEUR";

    private static final Logger LOG = LoggerFactory.getLogger(MediaPhoto.class);

    /**
     * Check criteres.
     */
    static {
        critereLimite = new CriterePhoto();
        critereVignette = new CriterePhoto();
        lstCriterePhoto = new ArrayList<>();
        String critere = PropertyHelper.getCoreProperty(MediathequeHelper.CRITERES_LIMITE_PROPERTIES_KEY);
        String[] lstLimite = critere.split("/", -2);
        critereLimite.setPoids(Long.parseLong(lstLimite[0]));
        critereLimite.setLargeur(Integer.parseInt(lstLimite[1]));
        critereLimite.setHauteur(Integer.parseInt(lstLimite[2]));
        LOG.debug("Critère limite construit : [ poids : {}, largeur {}: , hauteur : {}", lstLimite[0], lstLimite[1], lstLimite[2]);
        critere = PropertyHelper.getCoreProperty(MediathequeHelper.CRITERES_VIGNETTE_PROPERTIES_KEY);
        lstLimite = critere.split("/", -2);
        critereVignette.setCode(lstLimite[0]);
        critereVignette.setLargeur(Integer.parseInt(lstLimite[1]));
        critereVignette.setHauteur(Integer.parseInt(lstLimite[2]));
        final String dimension = PropertyHelper.getCoreProperty(MediathequeHelper.CRITERES_DIMENSION_PROPERTIES_KEY);
        LOG.debug("Critère vignette construit : [ code : {}, largeur {}: , hauteur : {}", lstLimite[0], lstLimite[1], lstLimite[2]);
        if (dimension != null) {
            final String[] lstDimension = dimension.split(";", -2);
            for (final String element : lstDimension) {
                critere = element;
                lstLimite = critere.split("/", -2);
                final CriterePhoto aCritere = new CriterePhoto();
                aCritere.setCode(lstLimite[0]);
                aCritere.setPoids(Long.parseLong(lstLimite[1]));
                aCritere.setLargeur(Integer.parseInt(lstLimite[2]));
                aCritere.setHauteur(Integer.parseInt(lstLimite[3]));
                lstCriterePhoto.add(aCritere);
            }
        }
        LOG.debug("Liste des critères photo (taille : {}) : " + lstCriterePhoto, lstCriterePhoto.size());
    }

    /* (non-Javadoc)
     * @see com.univ.objetspartages.processus.MediaSpecific#setSpecificProperties(com.jsbsoft.jtf.core.InfoBean, java.util.Properties)
     */
    @Override
    public void setSpecificProperties(final InfoBean infoBean, final Properties properties) throws Exception {
        String prop = "";
        if (infoBean.get(ATTRIBUT_LARGEUR) != null) {
            prop = infoBean.get(ATTRIBUT_LARGEUR).toString();
        }
        properties.setProperty(ATTRIBUT_LARGEUR, prop);
        prop = "";
        if (infoBean.get(ATTRIBUT_HAUTEUR) != null) {
            prop = infoBean.get(ATTRIBUT_HAUTEUR).toString();
        }
        properties.setProperty(ATTRIBUT_HAUTEUR, prop);
    }

    ;

    /* (non-Javadoc)
     * @see com.univ.objetspartages.processus.MediaSpecific#prepareMedia(com.jsbsoft.jtf.core.InfoBean, com.univ.objetspartages.om.RessourceUniv)
     */
    @Override
    public void prepareMedia(final InfoBean infoBean, final RessourceUniv media) throws Exception {
        setContenuInfoBean(infoBean, media.getSpecificData());
    }

    /* (non-Javadoc)
     * @see com.univ.objetspartages.processus.MediaSpecific#checkMedia(com.jsbsoft.jtf.core.InfoBean)
     */
    @Override
    public String checkMedia(final InfoBean infoBean, final UploadedFile file) throws Exception {
        // récupération du fichier uploadé
        // UploadedFile file = (UploadedFile) infoBean.get("MEDIA_FILE");
        File f = null;
        if (file != null) {
            f = file.getTemporaryFile();
        } else {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FICHIER_SOURCE_OBLIGATOIRE"));
        }
        boolean check = false;
        final ImageInfo ii = new ImageInfo();
        final String path = f.getAbsolutePath();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            ii.setInput(fis);
            check = ii.check();
        } catch (final Exception e) {
            throw new ErreurApplicative(e.getMessage());
        } finally {
            ii.close();
            if (fis != null) {
                fis.close();
            }
        }
        if (!check) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FORMAT_IMAGE"));
        }
        infoBean.set("SOURCE", file.getContentFilename());
        infoBean.set("POIDS", Long.toString(f.length() / 1024));
        if (StringUtils.isNotEmpty(file.getContentType())) {
            infoBean.set("FORMAT", file.getContentType());
        } else {
            String nomFichierUploade = file.getContentFilename();
            nomFichierUploade = StringUtils.defaultIfBlank(nomFichierUploade, f.getName());
            final String formatFichierUploade = Mediatheque.getInstance().getContentType(nomFichierUploade);
            infoBean.set("FORMAT", formatFichierUploade);
        }
        infoBean.set("LARGEUR", Integer.toString(ii.getWidth()));
        infoBean.set("HAUTEUR", Integer.toString(ii.getHeight()));
        infoBean.set("CRITERE", String.valueOf(lstCriterePhoto.size() + 1));
        infoBean.set("criteres", lstCriterePhoto);
        infoBean.set("HAUTEUR_PERSONNALISE", "");
        infoBean.set("LARGEUR_PERSONNALISE", "");
        LOG.debug("caractéristiques image : " + ii.getFormatName() + ", " + ii.getWidth() + " x " + ii.getHeight() + " pixels, " + ii.getBitsPerPixel() + " bits per pixel.");
        return f.getAbsolutePath();
    }

    /* (non-Javadoc)
     * @see com.univ.objetspartages.processus.MediaSpecific#processMedia(com.jsbsoft.jtf.core.InfoBean, com.univ.objetspartages.om.RessourceUniv)
     */
    @Override
    public String processMedia(final InfoBean infoBean, final RessourceUniv media) throws Exception {
        String sPathFile = infoBean.getString(INFOBEAN_KEY_URL_RESSOURCE);
        final String extension = FileUtil.getExtension(media.getSource());
        boolean replace = false;
        // Traitement du fichier uploadé si nouveau
        if (sPathFile.equals(media.getUrlAbsolue())) {
            replace = true;
            sPathFile = media.getPathAbsolu();
        }
        if ((String) infoBean.get("CRITERE") != null) {
            File f = new File(sPathFile);
            if (!f.exists()) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FICHIER_SOURCE_PHOTO_OBLIGATOIRE"));
            }
            final int index = Integer.parseInt((String) infoBean.get("CRITERE"));
            final int largeur = Integer.parseInt(infoBean.getString("LARGEUR"));
            final int hauteur = Integer.parseInt(infoBean.getString("HAUTEUR"));
            int newLargeur = largeur;
            int newHauteur = hauteur;
            if (index < lstCriterePhoto.size()) {
                final CriterePhoto critere = (CriterePhoto) lstCriterePhoto.get(index);
                newLargeur = critere.getLargeur();
                newHauteur = critere.getHauteur();
                final float rapportHauteur = (float) newHauteur / (float) (hauteur);
                final float rapportLargeur = (float) newLargeur / (float) (largeur);
                if (newLargeur == 0) {
                    newLargeur = (int) (largeur * rapportHauteur);
                } else if (newHauteur == 0) {
                    newHauteur = (int) (hauteur * rapportLargeur);
                } else if (rapportLargeur < rapportHauteur) {
                    newHauteur = (int) (hauteur * rapportLargeur);
                } else {
                    newLargeur = (int) (largeur * rapportHauteur);
                }
                f = PhotoUtil.resize(sPathFile, extension, newLargeur, newHauteur, replace);
            }
            // traitement personnalisé
            else if (index == lstCriterePhoto.size()) {
                newHauteur = (Integer) infoBean.get("HAUTEUR_PERSONNALISE");
                newLargeur = (Integer) infoBean.get("LARGEUR_PERSONNALISE");
                if ((newHauteur == 0) && (newLargeur == 0)) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.TAILLE_REDIMENSION"));
                }
                final float rapportHauteur = (float) newHauteur / (float) (hauteur);
                final float rapportLargeur = (float) newLargeur / (float) (largeur);
                if (newLargeur == 0) {
                    newLargeur = (int) (largeur * rapportHauteur);
                } else if (newHauteur == 0) {
                    newHauteur = (int) (hauteur * rapportLargeur);
                } else if (rapportLargeur < rapportHauteur) {
                    newHauteur = (int) (hauteur * rapportLargeur);
                } else {
                    newLargeur = (int) (largeur * rapportHauteur);
                }
                f = PhotoUtil.resize(sPathFile, extension, newLargeur, newHauteur, replace);
            }
            infoBean.set(ATTRIBUT_LARGEUR, Integer.toString(newLargeur));
            infoBean.set(ATTRIBUT_HAUTEUR, Integer.toString(newHauteur));
            infoBean.set("WIDTH", Integer.toString(newLargeur));
            infoBean.set("HEIGHT", Integer.toString(newHauteur));
            media.setSpecificData(getPropertiesAsString(infoBean));
            sPathFile = f.getAbsolutePath();
            media.setPoids(new Integer(Long.toString(f.length() / 1024)));
            // critères d'affichage
            if (newLargeur > critereLimite.getLargeur()) {
                newLargeur = critereLimite.getLargeur();
            }
            if (newHauteur > critereLimite.getHauteur()) {
                newHauteur = critereLimite.getHauteur();
            }
            infoBean.set(ATTRIBUT_LARGEUR, Integer.toString(newLargeur));
            infoBean.set(ATTRIBUT_HAUTEUR, Integer.toString(newHauteur));
        } else {
            sPathFile = media.getPathAbsolu();
        }
        if (infoBean.get("TYPE_MEDIA_" + getCode().toUpperCase()) != null && !infoBean.getString("TYPE_MEDIA_" + getCode().toUpperCase()).equals("0000")) {
            media.setTypeMedia(infoBean.getString("TYPE_MEDIA_" + getCode().toUpperCase()));
        }
        return sPathFile;
    }

    /* (non-Javadoc)
     * @see com.univ.objetspartages.om.MediaSpecific#processVignette(com.jsbsoft.jtf.core.InfoBean, com.univ.objetspartages.om.RessourceUniv)
     */
    @Override
    public String processVignette(final InfoBean infoBean, final RessourceUniv media) throws Exception {
        String sPathFile = infoBean.getString(INFOBEAN_KEY_URL_RESSOURCE);
        // si la source a change
        if (!sPathFile.equals(media.getUrlAbsolue())) {
            File f = new File(sPathFile);
            if (!f.exists()) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FICHIER_SOURCE_PHOTO_OBLIGATOIRE"));
            }
            // si la vignette existante a bien ete generee automatiquement a la base
            if (media.getUrlVignette().endsWith(media.getUrl())) {
                final String extension = FileUtil.getExtension(media.getSource());
                f = PhotoUtil.resize(f.getAbsolutePath(), extension, critereVignette.getLargeur(), critereVignette.getHauteur(), false);
                sPathFile = f.getAbsolutePath();
            }
        } else {
            sPathFile = media.getPathVignetteAbsolu();
        }
        return sPathFile;
    }

    /**
     * Gets the critere limite.
     *
     * @return the critere limite
     */
    public static CriterePhoto getCritereLimite() {
        return critereLimite;
    }

    /**
     * Gets the critere vignette.
     *
     * @return the critere vignette
     */
    public static CriterePhoto getCritereVignette() {
        return critereVignette;
    }
}
