/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.util.HashSet;

// TODO: Auto-generated Javadoc
/**
 * The Class NiveauPerimetre.
 */
public class NiveauPerimetre {

	/**
	 * Instantiates a new niveau perimetre.
	 */
	public NiveauPerimetre() {
		super();
	}

	/**
	 * Instantiates a new niveau perimetre.
	 * 
	 * @param _perimetre
	 *            the _perimetre
	 */
	public NiveauPerimetre(Perimetre _perimetre) {
		super();
		if (_perimetre.getCodeEspaceCollaboratif().length() == 0) {
			//si le perimetre est restreint sur un espace alors on ignore les autres champs
			codeStructure = _perimetre.getCodeStructure();
			codeRubrique = _perimetre.getCodeRubrique();
			codeGroupe = _perimetre.getCodeGroupe();
		}
		codeEspaceCollaboratif = _perimetre.getCodeEspaceCollaboratif();
		chaineSerialisee = _perimetre.getIdentifiantNiveau();
	}

	/** The code structure. */
	private String codeStructure = "";

	/** The code rubrique. */
	private String codeRubrique = "";

	/** The code groupe. */
	private String codeGroupe = "";

	/** The code espace collaboratif. */
	private String codeEspaceCollaboratif = "";

	/** The chaine serialisee. */
	private String chaineSerialisee = "";

	/** The lst enfant. */
	private HashSet<NiveauPerimetre> lstEnfant = new HashSet<NiveauPerimetre>();

	/** The lst parent. */
	private HashSet<NiveauPerimetre> lstParent = new HashSet<NiveauPerimetre>();

	/** The hash code chaine serialisee. */
	private int hashCodeChaineSerialisee = 0;

	/** The EGAL. */
	public static int EGAL = 0;

	/** The DESSOUS. */
	public static int DESSOUS = 1;

	/** The DESSUS. */
	public static int DESSUS = 2;

	/** The DIFFERENT. */
	public static int DIFFERENT = -1;

	/**
	 * To string.
	 * 
	 * @return Returns the lstEnfant.
	 */
	@Override
	public String toString() {
		return chaineSerialisee;
	}

	/**
	 * Gets the lst enfant.
	 * 
	 * @return Returns the lstEnfant.
	 */
	public HashSet<NiveauPerimetre> getLstEnfant() {
		return lstEnfant;
	}

	/**
	 * Sets the lst enfant.
	 * 
	 * @param lstEnfant
	 *            The lstEnfant to set.
	 */
	public void setLstEnfant(HashSet<NiveauPerimetre> lstEnfant) {
		this.lstEnfant = lstEnfant;
	}

	/**
	 * Gets the lst parent.
	 * 
	 * @return Returns the lstParent.
	 */
	public HashSet<NiveauPerimetre> getLstParent() {
		return lstParent;
	}

	/**
	 * Sets the lst parent.
	 * 
	 * @param lstParent
	 *            The lstParent to set.
	 */
	public void setLstParent(HashSet<NiveauPerimetre> lstParent) {
		this.lstParent = lstParent;
	}

	/**
	 * Gets the code groupe.
	 * 
	 * @return Returns the codeGroupe.
	 */
	public String getCodeGroupe() {
		return codeGroupe;
	}

	/**
	 * Sets the code groupe.
	 * 
	 * @param codeGroupe
	 *            The codeGroupe to set.
	 */
	public void setCodeGroupe(String codeGroupe) {
		this.codeGroupe = codeGroupe;
	}

	/**
	 * Gets the code rubrique.
	 * 
	 * @return Returns the codeRubrique.
	 */
	public String getCodeRubrique() {
		return codeRubrique;
	}

	/**
	 * Sets the code rubrique.
	 * 
	 * @param codeRubrique
	 *            The codeRubrique to set.
	 */
	public void setCodeRubrique(String codeRubrique) {
		this.codeRubrique = codeRubrique;
	}

	/**
	 * Gets the code structure.
	 * 
	 * @return Returns the codeStructure.
	 */
	public String getCodeStructure() {
		return codeStructure;
	}

	/**
	 * Sets the code structure.
	 * 
	 * @param codeStructure
	 *            The codeStructure to set.
	 */
	public void setCodeStructure(String codeStructure) {
		this.codeStructure = codeStructure;
	}

	/* public static NiveauPerimetre calculerPerimetreEffectifPermission(
	         Perimetre _perimetreAffectation, Perimetre _perimetreRole)
	 throws Exception {
	     
	     String codeStructure = _perimetreRole.getCodeStructure();
	     if (_perimetreAffectation.getCodeStructure().length() > 0)
	         codeStructure = _perimetreAffectation.getCodeStructure();
	     
	     String codeRubrique = _perimetreRole.getCodeRubrique();
	     if (_perimetreAffectation.getCodeRubrique().length() > 0)
	         codeRubrique = _perimetreAffectation.getCodeRubrique();
	     
	     String codeGroupe = _perimetreRole.getCodeGroupe();
	     if (_perimetreAffectation.getCodeGroupe().length() > 0)
	         codeGroupe = _perimetreAffectation.getCodeGroupe();
	     
	     
	     NiveauPerimetre res = new NiveauPerimetre(codeStructure, codeRubrique, codeGroupe);
	     return res;
	     
	 }*/
	/* (non-Javadoc)
	* @see java.lang.Object#equals(java.lang.Object)
	*/
	@Override
	public boolean equals(Object o) {
		return (chaineSerialisee.equals(o.toString()));
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		if (hashCodeChaineSerialisee == 0) {
			hashCodeChaineSerialisee = chaineSerialisee.hashCode();
		}
		return hashCodeChaineSerialisee;
	}

	/**
	 * Gets the niveau perimetre.
	 * 
	 * @param _perimetre
	 *            the _perimetre
	 * 
	 * @return the niveau perimetre
	 *
	 */
	public int getNiveauPerimetre(NiveauPerimetre _perimetre) {
		if (_perimetre.equals(this)) {
			return EGAL;
		}
		/*
		 * Gestion des rubriques
		 */
		int niveauRubrique = DIFFERENT;
		String codeRubriquePerimetre = _perimetre.getCodeRubrique();
		if (codeRubriquePerimetre.equals(codeRubrique)) {
			niveauRubrique = EGAL;
		} else if ("".equals(codeRubriquePerimetre)) {
			niveauRubrique = DESSOUS;
		} else if ("".equals(codeRubrique)) {
			niveauRubrique = DESSUS;
		} else if (codeRubrique.equals("-")) {
			niveauRubrique = DIFFERENT;
		} else if (codeRubriquePerimetre.equals("-")) {
			niveauRubrique = DIFFERENT;
		} else {
			InfosRubriques rubriquePerimetre = Rubrique.renvoyerItemRubrique(codeRubriquePerimetre);
			InfosRubriques rubriqueThis = Rubrique.renvoyerItemRubrique(codeRubrique);
			if (rubriquePerimetre.contains(rubriqueThis)) {
				niveauRubrique = DESSOUS;
			}
			if (rubriqueThis.contains(rubriquePerimetre)) {
				niveauRubrique = DESSUS;
			}
		}
		if (niveauRubrique == DIFFERENT) {
			return DIFFERENT;
		}
		/*
		 * Gestion des structures
		 */
		int niveauStructure = DIFFERENT;
		String codeStructurePerimetre = _perimetre.getCodeStructure();
		if (codeStructurePerimetre.equals(codeStructure)) {
			niveauStructure = EGAL;
		} else if ("".equals(codeStructurePerimetre)) {
			niveauStructure = DESSOUS;
		} else if ("".equals(codeStructure)) {
			niveauStructure = DESSUS;
		} else if (codeStructure.equals("-")) {
			niveauStructure = DIFFERENT;
		} else if (codeStructurePerimetre.equals("-")) {
			niveauStructure = DIFFERENT;
		} else {
			InfosStructure structurePerimetre = Structure.renvoyerItemStructure(codeStructurePerimetre);
			InfosStructure structureThis = Structure.renvoyerItemStructure(codeStructure);
			if (structurePerimetre.contains(structureThis)) {
				niveauStructure = DESSOUS;
			}
			if (structureThis.contains(structurePerimetre)) {
				niveauStructure = DESSUS;
			}
		}
		if (niveauStructure == DIFFERENT) {
			return DIFFERENT;
		}
		int niveauPerimetre = EGAL;
		if (niveauRubrique == niveauStructure) {
			niveauPerimetre = niveauRubrique;
		} else {
			if (niveauRubrique == EGAL) {
				niveauPerimetre = niveauStructure;
			} else if (niveauStructure == EGAL) {
				niveauPerimetre = niveauRubrique;
			} else {
				return DIFFERENT;
			}
		}
		/*
		 * Gestion groupes
		 */
		int niveauGroupes = DIFFERENT;
		String codeGroupePerimetre = _perimetre.getCodeGroupe();
		if (codeGroupePerimetre.equals(codeGroupe)) {
			niveauGroupes = EGAL;
		} else if (codeGroupePerimetre.length() == 0) {
			niveauGroupes = DESSOUS;
		} else if (codeGroupe.length() == 0) {
			niveauGroupes = DESSUS;
		} else if (codeGroupe.equals("-")) {
			niveauGroupes = DIFFERENT;
		} else if (codeGroupePerimetre.equals("-")) {
			niveauGroupes = DIFFERENT;
		} else {
			InfosGroupeDsi groupePerimetre = Groupedsi.renvoyerItemGroupeDsi(codeGroupePerimetre);
			InfosGroupeDsi groupeThis = Groupedsi.renvoyerItemGroupeDsi(codeGroupe);
			if (groupePerimetre.contains(groupeThis)) {
				niveauGroupes = DESSOUS;
			}
			if (groupeThis.contains(groupePerimetre)) {
				niveauGroupes = DESSUS;
			}
		}
		if (niveauGroupes == DIFFERENT) {
			return DIFFERENT;
		}
		if (niveauGroupes == niveauPerimetre) {
			return niveauPerimetre;
		} else {
			if (niveauGroupes == EGAL) {
				return niveauPerimetre;
			} else if (niveauPerimetre == EGAL) {
				return niveauGroupes;
			} else {
				return DIFFERENT;
			}
		}
	}

	/**
	 * Ajoute enfant.
	 * 
	 * @param _enfant
	 *            the _enfant
	 */
	public void ajouteEnfant(NiveauPerimetre _enfant) {
		if (lstEnfant == null) {
			lstEnfant = new HashSet<NiveauPerimetre>();
		}
		lstEnfant.add(_enfant);
	}

	/**
	 * Ajoute parent.
	 * 
	 * @param _parent
	 *            the _parent
	 */
	public void ajouteParent(NiveauPerimetre _parent) {
		if (lstParent == null) {
			lstParent = new HashSet<NiveauPerimetre>();
		}
		lstParent.add(_parent);
	}

	/**
	 * Gets the code espace collaboratif.
	 * 
	 * @return Returns the codeEspaceCollaboratif.
	 */
	public String getCodeEspaceCollaboratif() {
		return codeEspaceCollaboratif;
	}

	/**
	 * Sets the code espace collaboratif.
	 * 
	 * @param codeEspaceCollaboratif
	 *            The codeEspaceCollaboratif to set.
	 */
	public void setCodeEspaceCollaboratif(String codeEspaceCollaboratif) {
		this.codeEspaceCollaboratif = codeEspaceCollaboratif;
	}
}
