/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.io.File;

import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.sgbd.PhotoDB;

// TODO: Auto-generated Javadoc
/**
 * The Class Photo.
 */
public class Photo extends PhotoDB {

	/**
	 * Instantiates a new photo.
	 */
	public Photo() {
		super();
	}

	/**
	 * Inits the.
	 */
	public void init() {
		setIdPhoto(new Long(0));
		setDescription("");
		setTitre("");
		setLegende("");
		setTypePhoto("");
		setLargeur(new Integer(0));
		setHauteur(new Integer(0));
		setCodeStructure("");
		setUrl("");
		setPath("");
		setDateCreation(new java.sql.Date(System.currentTimeMillis()));
		setCodeRedacteur("");
		setMetaKeywords("");
		setCodeRubrique("");
	}

	/**
	 * Gets the path absolu.
	 * 
	 * @return the path absolu
	 */
	public String getPathAbsolu() {
		return PropertyHelper.getCoreProperty("phototheque.path") + File.separator + getUrl().replace('/', File.separatorChar);
	}

	/**
	 * Gets the url absolue.
	 * 
	 * @return the url absolue
	 */
	public String getUrlAbsolue() {
		return PropertyHelper.getCoreProperty("phototheque.url") + getUrl();
	}
}
