/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.univ.objetspartages.sgbd.PreferencesDB;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseOrderBy.SensDeTri;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;

// TODO: Auto-generated Javadoc
/**
 * The Class Preferences.
 */
public class Preferences extends PreferencesDB {

	/** The Constant TYPE_SERVICE. */
	public final static String TYPE_SERVICE = "S";

	/** Constante permettant de ramener toutes les préférences. */
	public final static String TOUS_SERVICES = "TOUS";

	/**
	 * Instantiates a new preferences.
	 */
	public Preferences() {
		super();
	}

	/**
	 * Inits the.
	 */
	public void init() {
		setIdPreferences(new Long(0));
		setCodeUtilisateur("");
		setType("");
		setNom("");
		setValeur("");
	}

	/**
	 * Méthode permettant de retourner les préférences associées à un utilisateur.
	 * 
	 * @param codeUser
	 *            the code user
	 * 
	 * @return the int
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public int selectPreferencesUser(final String codeUser) throws Exception {
		int resultat = 0;
		if (codeUser != null) {
			final RequeteSQL requeteParPreferencesUser = new RequeteSQL();
			final ClauseOrderBy orderBy = new ClauseOrderBy("T1.SERVICE", SensDeTri.ASC);
			final ClauseWhere where = new ClauseWhere();
			where.setPremiereCondition(ConditionHelper.egalVarchar("T1.CODE_UTILISATEUR", codeUser));
			where.and(ConditionHelper.egalVarchar("T1.TYPE", TYPE_SERVICE));
			requeteParPreferencesUser.where(where).orderBy(orderBy);
			resultat = select(requeteParPreferencesUser.formaterRequete());
		}
		return resultat;
	}

	/**
	 * Select user preferences.
	 * 
	 * @param codeUser
	 *            the code user
	 * @param service
	 *            the service
	 * @param nom
	 *            the nom
	 * 
	 * @return the int
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public int selectUserPreferences(final String codeUser, final String service, final String nom) throws Exception {
		final ClauseWhere whereUserTypeServiceNom = new ClauseWhere();
		whereUserTypeServiceNom.setPremiereCondition(ConditionHelper.egalVarchar("T1.CODE_UTILISATEUR", codeUser));
		whereUserTypeServiceNom.and(ConditionHelper.egalVarchar("T1.TYPE", TYPE_SERVICE));
		whereUserTypeServiceNom.and(ConditionHelper.egalVarchar("T1.SERVICE", service));
		whereUserTypeServiceNom.and(ConditionHelper.egalVarchar("T1.NOM", nom));
		return select(whereUserTypeServiceNom.formaterSQL());
	}

	/**
	 * Suppression des préférences associées à un services.
	 * 
	 * @param codeService
	 *            the code service
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public void deleteAllPreferences(final String codeService) throws Exception {
		if (codeService != null) {
			final ClauseWhere whereTypeService = new ClauseWhere();
			whereTypeService.setPremiereCondition(ConditionHelper.egalVarchar("T1.TYPE", TYPE_SERVICE));
			whereTypeService.and(ConditionHelper.egalVarchar("T1.SERVICE", codeService));
			select(whereTypeService.formaterSQL());
			while (nextItem()) {
				delete();
			}
		}
	}

	/**
	 * Méthode permettant de retourner les préférences générales.
	 * 
	 * @param codeService
	 *            the code service
	 * 
	 * @return the int
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public int selectPreferencesGenerales(final String codeService) throws Exception {
		final RequeteSQL requeteParPreferencesUser = new RequeteSQL();
		final ClauseOrderBy orderBy = new ClauseOrderBy("T1.SERVICE", SensDeTri.ASC);
		final ClauseWhere where = new ClauseWhere();
		where.setPremiereCondition(ConditionHelper.egalVarchar("T1.TYPE", TYPE_SERVICE));
		final ConditionList conditionCodeUtilisateur = new ConditionList(ConditionHelper.egalVarchar("T1.CODE_UTILISATEUR", ""));
		conditionCodeUtilisateur.or(ConditionHelper.isNull("T1.CODE_UTILISATEUR"));
		where.and(conditionCodeUtilisateur);
		if (StringUtils.isNotEmpty(codeService) && !TOUS_SERVICES.equals(codeService)) {
			where.and(ConditionHelper.egalVarchar("T1.SERVICE ", codeService));
		}
		requeteParPreferencesUser.where(where).orderBy(orderBy);
		return select(requeteParPreferencesUser.formaterRequete());
	}

	/**
	 * Gets the liste valeur preference.
	 * 
	 * @param valeur
	 *            the valeur
	 * 
	 * @return the liste valeur preference
	 */
	public static List<String> getListeValeurPreference(String valeur) {
		//        String valeur = this.getValeur();
		final List<String> listeValeurs = new ArrayList<String>();
		int index = valeur.indexOf(";");
		String mot = "";
		while (index != -1) {
			if (index != valeur.length() && index != (valeur.length() - 1) && ";".equals(valeur.substring(index + 1, index + 2))) {
				valeur = valeur.replaceFirst(";;", ";");
				mot = mot + valeur.substring(0, index + 1);
				valeur = valeur.substring(index + 1);
			} else {
				listeValeurs.add(mot + valeur.substring(0, index));
				valeur = valeur.substring(index + 1);
				mot = "";
			}
			index = valeur.indexOf(";");
		}
		if (!"".equals(valeur) || !"".equals(mot)) {
			listeValeurs.add(mot + valeur);
		}
		return listeValeurs;
	}

	/**
	 * Méthode permettant d'affecter les valeurs contenues dans la liste. Cette méthode est appelée lors de la création d'une préférence utilisateur depuis le porletPreference.
	 * 
	 * @param itValues
	 *            the it values
	 */
	public void setValues(final Iterator<String> itValues) {
		String value = "";
		while (itValues.hasNext()) {
			String val = itValues.next();
			val = val.replaceAll(";", ";;");
			if ("".equals(value)) {
				value = val;
			} else {
				value = value + ";" + val;
			}
		}
		this.setValeur(value);
	}

	/**
	 * Delete user preferences.
	 * 
	 * @param codeUser
	 *            the code user
	 */
	public void deleteUserPreferences(final String codeUser) {}
}
