/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/**
 * The Class ServiceBean.
 *
 * @author jean-sébastien steux
 *
 *         Stockage en mémoire des caractéristiques d'un service
 */
public class ServiceBean implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -1245708607172931004L;

	/** The code. */
	private String code = "";

	/** The intitule. */
	private String intitule = "";

	/** The type. */
	private String type = "0";

	/** The encodage. */
	private String encodage = "";

	/** The expiration cache. */
	private Integer expirationCache = new Integer(0);

	/** The expiration cache service. */
	private Integer expirationCacheService = new Integer(0);

	/** The jeton kportal. */
	private String jetonKportal = "0";

	/** The proxy cas. */
	private String proxyCas = "0";

	/** The url. */
	private String url = "";

	/** The portlet definition id. */
	private String portletDefinitionId = "";

	/** The url popup. */
	private String urlPopup = "0";

	/** The vue reduite type. */
	private String vueReduiteType = "";

	/** The vue reduite url. */
	private String vueReduiteUrl = "";

	/** The vue reduite ctx. */
	private String vueReduiteCtx = "";

	/** The vue reduite url cross ctx. */
	private String vueReduiteUrlCrossCtx = "";

	/** The diffusion mode. */
	private String diffusionMode = "0";

	/** The diffusion public vise. */
	private Vector<String> diffusionPublicVise = new Vector<String>();

	/** The diffusion mode restriction. */
	private String diffusionModeRestriction = "";

	/** The diffusion public vise restriction. */
	private Vector<String> diffusionPublicViseRestriction = new Vector<String>();

	/** The preferences generales. */
	private List<InfosPreferences> preferencesGenerales = new ArrayList<InfosPreferences>();

	/**
	 * The Constructor.
	 *
	 * @param code
	 *            the code
	 * @param intitule
	 *            the intitule
	 * @param type
	 *            the type
	 * @param encodage
	 *            the encodage
	 * @param expirationCache
	 *            the expiration cache
	 * @param expirationCacheService
	 *            the expiration cache service
	 * @param jetonKportal
	 *            the jeton kportal
	 * @param proxyCas
	 *            the proxy cas
	 * @param url
	 *            the url
	 * @param portletDefinitionId
	 *            the portlet definition id
	 * @param urlPopup
	 *            the url popup
	 * @param vueReduiteType
	 *            the vue reduite type
	 * @param vueReduiteUrl
	 *            the vue reduite url
	 * @param vueReduiteCtx
	 *            the vue reduite ctx
	 * @param vueReduiteUrlCrossCtx
	 *            the vue reduite url cross ctx
	 * @param diffusionMode
	 *            the diffusion mode
	 * @param diffusionPublicVise
	 *            the diffusion public vise
	 * @param diffusionModeRestriction
	 *            the diffusion mode restriction
	 * @param diffusionPublicViseRestriction
	 *            the diffusion public vise restriction
	 * @param preferencesGenerales
	 *            the preferences generales
	 */
	public ServiceBean(final String code, final String intitule, final String type, final String encodage, final Integer expirationCache, final Integer expirationCacheService,
		final String jetonKportal, final String proxyCas, final String url, final String portletDefinitionId, final String urlPopup, final String vueReduiteType,
		final String vueReduiteUrl, final String vueReduiteCtx, final String vueReduiteUrlCrossCtx, final String diffusionMode, final Vector<String> diffusionPublicVise,
		final String diffusionModeRestriction, final Vector<String> diffusionPublicViseRestriction, final List<InfosPreferences> preferencesGenerales) {
		this.code = code;
		this.intitule = intitule;
		this.type = type;
		this.encodage = encodage;
		this.expirationCache = expirationCache;
		this.expirationCacheService = expirationCacheService;
		this.jetonKportal = jetonKportal;
		this.proxyCas = proxyCas;
		this.url = url;
		this.portletDefinitionId = portletDefinitionId;
		this.urlPopup = urlPopup;
		this.vueReduiteType = vueReduiteType;
		this.vueReduiteUrl = vueReduiteUrl;
		this.vueReduiteUrlCrossCtx = vueReduiteUrlCrossCtx;
		this.vueReduiteCtx = vueReduiteCtx;
		this.diffusionMode = diffusionMode;
		this.diffusionPublicVise = diffusionPublicVise;
		this.diffusionModeRestriction = diffusionModeRestriction;
		this.diffusionPublicViseRestriction = diffusionPublicViseRestriction;
		this.preferencesGenerales = preferencesGenerales;
	}

	/**
	 * Instantiates a new service bean.
	 */
	public ServiceBean() {
		super();
	}

	/**
	 * Gets the vue reduite ctx.
	 *
	 * @return the vue reduite ctx
	 */
	public String getVueReduiteCtx() {
		return vueReduiteCtx;
	}

	/**
	 * Gets the code.
	 *
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * Gets the intitule.
	 *
	 * @return the intitule
	 */
	public String getIntitule() {
		return intitule;
	}

	/**
	 * Gets the diffusion mode restriction.
	 *
	 * @return the diffusion mode restriction
	 */
	public String getDiffusionModeRestriction() {
		return diffusionModeRestriction;
	}

	/**
	 * Gets the diffusion public vise.
	 *
	 * @return the diffusion public vise
	 */
	public Vector<String> getDiffusionPublicVise() {
		return diffusionPublicVise;
	}

	/**
	 * Gets the diffusion public vise restriction.
	 *
	 * @return the diffusion public vise restriction
	 */
	public Vector<String> getDiffusionPublicViseRestriction() {
		return diffusionPublicViseRestriction;
	}

	/**
	 * Gets the type.
	 *
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * Gets the url.
	 *
	 * @return the url
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * Gets the vue reduite type.
	 *
	 * @return the vue reduite type
	 */
	public String getVueReduiteType() {
		return vueReduiteType;
	}

	/**
	 * Gets the vue reduite url.
	 *
	 * @return the vue reduite url
	 */
	public String getVueReduiteUrl() {
		return vueReduiteUrl;
	}

	/**
	 * Gets the jeton kportal.
	 *
	 * @return the jeton kportal
	 */
	public String getJetonKportal() {
		return jetonKportal;
	}

	/**
	 * Gets the diffusion mode.
	 *
	 * @return the diffusion mode
	 */
	public String getDiffusionMode() {
		return diffusionMode;
	}

	/**
	 * Gets the vue reduite url cross ctx.
	 *
	 * @return the vue reduite url cross ctx
	 */
	public String getVueReduiteUrlCrossCtx() {
		return vueReduiteUrlCrossCtx;
	}

	/**
	 * Gets the url popup.
	 *
	 * @return the url popup
	 */
	public String getUrlPopup() {
		return urlPopup;
	}

	/**
	 * Gets the encodage.
	 *
	 * @return the encodage
	 */
	public String getEncodage() {
		return encodage;
	}

	/**
	 * Gets the expiration cache.
	 *
	 * @return the expiration cache
	 */
	public Integer getExpirationCache() {
		return expirationCache;
	}

	/**
	 * Gets the portlet definition id.
	 *
	 * @return the portlet definition id
	 */
	public String getPortletDefinitionId() {
		return portletDefinitionId;
	}

	/**
	 * Gets the preferences generales.
	 *
	 * @return the preferences generales
	 */
	public List<InfosPreferences> getPreferencesGenerales() {
		return preferencesGenerales;
	}

	/**
	 * Gets the proxy cas.
	 *
	 * @return the proxy cas
	 */
	public String getProxyCas() {
		return proxyCas;
	}

	/**
	 * Gets the expiration cache service.
	 *
	 * @return the expiration cache service
	 */
	public Integer getExpirationCacheService() {
		return expirationCacheService;
	}
}