/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.textsearch.util.IndexationHelper;
import com.univ.objetspartages.sgbd.SiteDB;

/**
 * The Class Site.
 */
public class Site extends SiteDB {

	private static final Logger LOGGER = LoggerFactory.getLogger(Site.class);

	private String etatIndexation;

	public String getEtatIndexation() {
		return etatIndexation;
	}

	public void setEtatIndexation(final String etatIndexation) {
		this.etatIndexation = etatIndexation;
	}

	/**
	 * Renvoie la liste des sites.
	 * 
	 * @param ctx
	 *            the ctx
	 * 
	 * @return the liste sites
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public static List<Site> getListeSites(final OMContext ctx) throws Exception {
		final Site site = new Site();
		site.setCtx(ctx);
		final int count = site.select(" order by CODE");
		final List<Site> listeSites = new ArrayList<Site>(count);
		while (site.nextItem()) {
			listeSites.add((Site) site.clone());
		}
		return listeSites;
	}

	/**
	 * Inits the.
	 */
	public void init() {
		setIdSite(new Long(System.currentTimeMillis()));
		setCode(String.valueOf(System.currentTimeMillis()));
		setLibelle("");
		setUrl("");
		setLangue("0");
		setRegExpAccepte("");
		setRegExpRefuse("");
		setNiveauProfondeur(new Integer(-1));
	}

	/**
	 * Fait une copie des proprietes d'un site. Utilise pour l'empilement de site a indexer.
	 * 
	 * @return copie du site
	 */
	@Override
	public Object clone() {
		final Site siteDest = new Site();
		siteDest.init();
		siteDest.setCode(getCode());
		siteDest.setIdSite(new Long(getIdSite().longValue()));
		siteDest.setLangue(getLangue());
		siteDest.setLibelle(getLibelle());
		siteDest.setRegExpAccepte(getRegExpAccepte());
		siteDest.setRegExpRefuse(getRegExpRefuse());
		siteDest.setNiveauProfondeur(new Integer(getNiveauProfondeur().intValue()));
		siteDest.setUrl(getUrl());
		return siteDest;
	}

	/**
	 * Recopie.
	 * 
	 * @param siteSrc
	 *            the site src
	 * 
	 * @return the site
	 * 
	 * @deprecated : utiliser la methode standard clone
	 */
	@Deprecated
	public Site recopie(final Site siteSrc) {
		return (Site) siteSrc.clone();
	}

	/**
	 * Renvoie le répertoire de stockage des index.
	 * 
	 * @return the repertoire indexation
	 */
	public File getRepertoireIndexation() {
		File repertoireIndexation = null;
		try {
			final String indexDir = IndexationHelper.getWorkDirectory() + File.separator + getLangue() + File.separator + getCode();
			repertoireIndexation = new File(indexDir);
			if (!repertoireIndexation.exists()) {
				repertoireIndexation.mkdir();
			}
		} catch (final Exception e) {
			LOGGER.error("erreur lors de la création du dossier", e);
		}
		return repertoireIndexation;
	}
}
