/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.om;

// TODO: Auto-generated Javadoc
/**
 * The Interface StructureModele.
 * 
 * @author malice
 * 
 *         Interface qui permet à un objet d'apparaître dans l'arbre des structures et de faire partie de la famille des objets de type "Structure"
 */
public interface StructureModele extends FicheUniv {

	/**
	 * Gets the libelle court.
	 * 
	 * @return the libelle court
	 */
	public String getLibelleCourt();
	public void setLibelleCourt(String libelle);

	/**
	 * Gets the libelle long.
	 * 
	 * @return the libelle long
	 */
	public String getLibelleLong();
	public void setLibelleLong(String libelle);

	/**
	 * Gets the onglets.
	 * 
	 * @return the onglets
	 */
	public String getOnglets();
	public void setOnglets(String onglets);

	/**
	 * Gets the type structure.
	 * 
	 * @return the type structure
	 */
	public String getTypeStructure();
	public void setTypeStructure(String typeStructure);

	/**
	 * Gets the id bandeau.
	 * 
	 * @return the id bandeau
	 */
	public Long getIdBandeau();
	public void setIdBandeau(Long idBandeau);

	/**
	 * Gets the couleur titre.
	 * 
	 * @return the couleur titre
	 */
	public String getCouleurTitre();
	public void setCouleurTitre(String couleurTitre);

	/**
	 * Gets the couleur fond.
	 * 
	 * @return the couleur fond
	 */
	public String getCouleurFond();
	public void setCouleurFond(String couleurFond);

	/**
	 * Gets the adresse.
	 * 
	 * @return the adresse
	 */
	public String getAdresse();
	public void setAdresse(String adresse);

	/**
	 * Gets the code postal.
	 * 
	 * @return the code postal
	 */
	public String getCodePostal();
	public void setCodePostal(String codePostal);

	/**
	 * Gets the ville.
	 * 
	 * @return the ville
	 */
	public String getVille();
	public void setVille(String ville);

	/**
	 * Gets the telephone.
	 * 
	 * @return the telephone
	 */
	public String getTelephone();
	public void setTelephone(String telephone);

	/**
	 * Gets the telecopie.
	 * 
	 * @return the telecopie
	 */
	public String getTelecopie();
	public void setTelecopie(String telecopie);

	/**
	 * Gets the adresse mail.
	 * 
	 * @return the adresse mail
	 */
	public String getAdresseMail();
	public void setAdresseMail(String adresseMail);

	/**
	 * Gets the site web.
	 * 
	 * @return the site web
	 */
	public String getSiteWeb();
	public void setSiteWeb(String siteWeb);

	/**
	 * Gets the id plan acces.
	 * 
	 * @return the id plan acces
	 */
	public Long getIdPlanAcces();

	/**
	 * Gets the attribut specifique1.
	 * 
	 * @return the attribut specifique1
	 */
	public String getAttributSpecifique1();

	/**
	 * Gets the attribut specifique2.
	 * 
	 * @return the attribut specifique2
	 * 
	 */
	public String getAttributSpecifique2();

	/**
	 * Gets the attribut specifique3.
	 * 
	 * @return the attribut specifique3
	 */
	public String getAttributSpecifique3();

	/**
	 * Gets the attribut specifique4.
	 * 
	 * @return the attribut specifique4
	 */
	public String getAttributSpecifique4();

	/**
	 * Gets the attribut specifique5.
	 * 
	 * @return the attribut specifique5
	 */
	public String getAttributSpecifique5();

	public String getComplementCoordonnees();
	public void setComplementCoordonnees(String complements);

	public String getActivite();
	public void setActivite(String activite);

	public String getCodeResponsable();
	public void setCodeResponsable(String codeResponsable);
}
