/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.processus;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosRole;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Role;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;

/**
 * Saisie des affectations de roles
 */
public class ControleurAffectationRole {

	/**
	 * Preparer principal.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ctx
	 *            the ctx
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public static void preparerPRINCIPAL(final InfoBean infoBean, final OMContext ctx) throws Exception {
		/*
		 * Les roles sont dans da variable ROLE de l'infoBean sous la forme
		 * ([perimetr1;role1][perimètre2;role2]
		 */
		final StringTokenizer st = new StringTokenizer(StringUtils.defaultString(infoBean.getString("ROLES")), "[]");
		int i = 0;
		while (st.hasMoreTokens()) {
			final String val = st.nextToken();
			final int indexPointVirgule = val.indexOf(';');
			if (indexPointVirgule != -1) {
				final String codeRole = val.substring(0, indexPointVirgule);
				final InfosRole infosRole = Role.renvoyerItemRole(codeRole);
				//on verifie que le role existe
				if (infosRole.getCode().length() > 0) {
					final String sPerimetre = val.substring(indexPointVirgule + 1);
					final Perimetre perimetre = new Perimetre(sPerimetre);
					//              	 infoBean.set("STRUCTURE_AFFECTATION#" + i, perimetre
					//              	 .getCodeStructure());
					//              	 
					//              	 infoBean.set("RUBRIQUE_AFFECTATION#" + i, perimetre
					//              	 .getCodeRubrique());
					//              	 
					//              	 // JSS 20050510 : profil dynamique
					//              	 //infoBean.set("PROFIL_AFFECTATION#" + i, perimetre
					//              	 //        .getCodeProfil());
					//              	 
					//              	 infoBean.set("GROUPE_AFFECTATION#" + i, perimetre
					//              	 .getCodeGroupe());
					// JSS 20051104 : périmètres
					infoBean.set("STRUCTURE_TYPE_AFFECTATION#" + i, "");
					infoBean.set("STRUCTURE_AFFECTATION#" + i, "");
					if (perimetre.getCodeStructure().equals("")) {
						infoBean.set("STRUCTURE_TYPE_AFFECTATION#" + i, "0");
					} else if (perimetre.getCodeStructure().equals("-")) {
						infoBean.set("STRUCTURE_TYPE_AFFECTATION#" + i, "2");
					} else {
						infoBean.set("STRUCTURE_TYPE_AFFECTATION#" + i, "1");
						infoBean.set("STRUCTURE_AFFECTATION#" + i, perimetre.getCodeStructure());
					}
					infoBean.set("RUBRIQUE_TYPE_AFFECTATION#" + i, "");
					infoBean.set("RUBRIQUE_AFFECTATION#" + i, "");
					if (perimetre.getCodeRubrique().equals("")) {
						infoBean.set("RUBRIQUE_TYPE_AFFECTATION#" + i, "0");
					} else if (perimetre.getCodeRubrique().equals("-")) {
						infoBean.set("RUBRIQUE_TYPE_AFFECTATION#" + i, "2");
					} else {
						infoBean.set("RUBRIQUE_TYPE_AFFECTATION#" + i, "1");
						infoBean.set("RUBRIQUE_AFFECTATION#" + i, perimetre.getCodeRubrique());
					}
					infoBean.set("GROUPE_TYPE_AFFECTATION#" + i, "");
					infoBean.set("GROUPE_AFFECTATION#" + i, "");
					if (perimetre.getCodeGroupe().equals("")) {
						infoBean.set("GROUPE_TYPE_AFFECTATION#" + i, "0");
					} else if (perimetre.getCodeGroupe().equals("-")) {
						infoBean.set("GROUPE_TYPE_AFFECTATION#" + i, "2");
					} else {
						infoBean.set("GROUPE_TYPE_AFFECTATION#" + i, "1");
						infoBean.set("GROUPE_AFFECTATION#" + i, perimetre.getCodeGroupe());
					}
					infoBean.set("ROLE_AFFECTATION#" + i, codeRole);
					i++;
				}//fin if role existe
			}
		}
		infoBean.setInt("AFFECTATIONS_NB_ITEMS", i);
		rafraichirPRINCIPAL(infoBean, ctx);
	}

	/**
	 * préparation des intitulés à afficher.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ctx
	 *            the ctx
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public static void rafraichirPRINCIPAL(final InfoBean infoBean, final OMContext ctx) throws Exception {
		/* Liste des roles */
		final Hashtable<String, String> hRoles = Role.getListeRolesHorsEspace();
		infoBean.set("LISTE_ROLES", hRoles);
		final Enumeration<String> enu = hRoles.keys();
		int j = 0;
		String codeRole = "";
		boolean perimetreRubrique = false;
		boolean perimetreStructure = false;
		boolean perimetreGroupe = false;
		boolean permissionTraitee = false;
		while (enu.hasMoreElements()) {
			codeRole = enu.nextElement();
			final InfosRole infosRole = Role.renvoyerItemRole(codeRole);
			final Vector<PermissionBean> vPermissions = infosRole.getVecteurPermissions();
			final Iterator<PermissionBean> it = vPermissions.iterator();
			infoBean.set("ROLE_" + j, codeRole);
			infoBean.set("PERIMETRE_RUBRIQUE_" + j, "0");
			infoBean.set("PERIMETRE_STRUCTURE_" + j, "0");
			infoBean.set("PERIMETRE_GROUPE_" + j, "0");
			perimetreRubrique = false;
			perimetreStructure = false;
			perimetreGroupe = false;
			permissionTraitee = false;
			while (it.hasNext() && !permissionTraitee) {
				final PermissionBean pb = it.next();
				if ((!perimetreRubrique || !perimetreStructure) && ((pb.getType().equalsIgnoreCase("FICHE")) || (pb.getType().equalsIgnoreCase("TECH") && pb.getObjet().equalsIgnoreCase(
					"rub")) || (pb.getType().equalsIgnoreCase("TECH") && pb.getObjet().equalsIgnoreCase("fil")) || (pb.getType().equalsIgnoreCase("TECH") && pb.getObjet().equalsIgnoreCase(
					"pho")) || (pb.getType().equalsIgnoreCase("TECH") && pb.getObjet().equalsIgnoreCase("pub")) || (pb.getType().equalsIgnoreCase("TECH") && pb.getObjet().equalsIgnoreCase(
					"acp")) || (pb.getType().equalsIgnoreCase("TECH") && pb.getObjet().equalsIgnoreCase("enc")) || (pb.getType().equalsIgnoreCase("TECH") && pb.getObjet().equalsIgnoreCase(
					"new")) || (pb.getType().equalsIgnoreCase("TECH") && pb.getObjet().equalsIgnoreCase("for")))) {
					infoBean.set("PERIMETRE_RUBRIQUE_" + j, "1");
					infoBean.set("PERIMETRE_STRUCTURE_" + j, "1");
					perimetreRubrique = true;
					perimetreStructure = true;
				}
				if (!perimetreGroupe && pb.getType().equalsIgnoreCase("TECH") && pb.getObjet().equalsIgnoreCase("dsi")) {
					infoBean.set("PERIMETRE_GROUPE_" + j, "1");
					perimetreGroupe = true;
				}
				if (perimetreRubrique && perimetreStructure && perimetreGroupe) {
					permissionTraitee = true;
				}
			}
			j++;
		}
		infoBean.setInt("ROLES_NB_ITEMS", j);
		/* Liste des profils */
		//		JSS 20050510 : profil dynamique
		//infoBean.set("LISTE_PROFILS", Profildsi.getListeProfilsDSI(ctx));
		for (int i = 0; i < infoBean.getInt("AFFECTATIONS_NB_ITEMS"); i++) {
			/* Intitulés */
			final InfosRole infosRole = Role.renvoyerItemRole(infoBean.getString("ROLE_AFFECTATION#" + i));
			final String intituleRole = infosRole.getIntitule();
			final Perimetre perimetreRole = new Perimetre(infosRole.getPerimetre());
			// JSS 20051104 : gestion des périmètres
			String structurePerimetre = "";
			if (StringUtils.isNotBlank("STRUCTURE_AFFECTATION#" + i)) {
				structurePerimetre = infoBean.getString("STRUCTURE_AFFECTATION#" + i);
			}
			String rubriquePerimetre = "";
			if (StringUtils.isNotBlank(infoBean.getString("RUBRIQUE_AFFECTATION#" + i))) {
				rubriquePerimetre = infoBean.getString("RUBRIQUE_AFFECTATION#" + i);
			}
			String groupePerimetre = "";
			if (StringUtils.isNotBlank(infoBean.getString("GROUPE_AFFECTATION#" + i))) {
				groupePerimetre = infoBean.getString("GROUPE_AFFECTATION#" + i);
			}
			final Perimetre perimetreAffectation = new Perimetre(structurePerimetre, rubriquePerimetre, "", groupePerimetre, "");
			final Perimetre perimetrePermission = Perimetre.calculerPerimetrePermission(perimetreAffectation, perimetreRole);
			String intitulePerimetre = "";
			if (perimetrePermission == null) {
				intitulePerimetre = "Périmètre invalide";
				infoBean.set("AFFECTATION_PERIMETRE_RUBRIQUE#" + i, intitulePerimetre);
				infoBean.set("AFFECTATION_PERIMETRE_STRUCTURE#" + i, intitulePerimetre);
				infoBean.set("AFFECTATION_PERIMETRE_GROUPE#" + i, intitulePerimetre);
			} else {
				if (perimetrePermission.getCodeStructure().equals("")) {
					intitulePerimetre = "Toutes structures";
				} else if (perimetrePermission.getCodeStructure().equals("-")) {
					intitulePerimetre = "Aucune structure";
				} else {
					intitulePerimetre = "Structure : " + Structure.getFilAriane(perimetrePermission.getCodeStructure(), "");
				}
				infoBean.set("AFFECTATION_PERIMETRE_STRUCTURE#" + i, intitulePerimetre);
				infoBean.set("STRUCTURE_TYPE_AFFECTATION#" + i, "");
				infoBean.set("STRUCTURE_AFFECTATION#" + i, "");
				if (perimetrePermission.getCodeStructure().equals("")) {
					infoBean.set("STRUCTURE_TYPE_AFFECTATION#" + i, "0");
				} else if (perimetrePermission.getCodeStructure().equals("-")) {
					infoBean.set("STRUCTURE_TYPE_AFFECTATION#" + i, "2");
				} else {
					infoBean.set("STRUCTURE_TYPE_AFFECTATION#" + i, "1");
					infoBean.set("STRUCTURE_AFFECTATION#" + i, perimetrePermission.getCodeStructure());
				}
				if (perimetrePermission.getCodeRubrique().equals("")) {
					intitulePerimetre = "Toutes rubriques";
				} else if (perimetrePermission.getCodeRubrique().equals("-")) {
					intitulePerimetre = "Aucune rubrique";
				} else {
					intitulePerimetre = "Rubrique : " + Rubrique.getFilAriane(perimetrePermission.getCodeRubrique(), "");
				}
				infoBean.set("AFFECTATION_PERIMETRE_RUBRIQUE#" + i, intitulePerimetre);
				infoBean.set("RUBRIQUE_TYPE_AFFECTATION#" + i, "");
				infoBean.set("RUBRIQUE_AFFECTATION#" + i, "");
				if (perimetrePermission.getCodeRubrique().equals("")) {
					infoBean.set("RUBRIQUE_TYPE_AFFECTATION#" + i, "0");
				} else if (perimetrePermission.getCodeRubrique().equals("-")) {
					infoBean.set("RUBRIQUE_TYPE_AFFECTATION#" + i, "2");
				} else {
					infoBean.set("RUBRIQUE_TYPE_AFFECTATION#" + i, "1");
					infoBean.set("RUBRIQUE_AFFECTATION#" + i, perimetrePermission.getCodeRubrique());
				}
				if (perimetrePermission.getCodeGroupe().equals("")) {
					intitulePerimetre = "Tous groupes";
				} else if (perimetrePermission.getCodeGroupe().equals("-")) {
					intitulePerimetre = "Aucun groupe";
				} else {
					intitulePerimetre = "Groupe : " + Groupedsi.getFilAriane(perimetrePermission.getCodeGroupe(), "");
				}
				infoBean.set("AFFECTATION_PERIMETRE_GROUPE#" + i, intitulePerimetre);
				infoBean.set("GROUPE_TYPE_AFFECTATION#" + i, "");
				infoBean.set("GROUPE_AFFECTATION#" + i, "");
				if (perimetrePermission.getCodeGroupe().equals("")) {
					infoBean.set("GROUPE_TYPE_AFFECTATION#" + i, "0");
				} else if (perimetrePermission.getCodeGroupe().equals("-")) {
					infoBean.set("GROUPE_TYPE_AFFECTATION#" + i, "2");
				} else {
					infoBean.set("GROUPE_TYPE_AFFECTATION#" + i, "1");
					infoBean.set("GROUPE_AFFECTATION#" + i, perimetrePermission.getCodeGroupe());
				}
			}
			infoBean.set("AFFECTATION_INTITULE#" + i, intituleRole);
			for (final Role currentRole : Role.getAllRolesWithoutCollab()) {
				if (currentRole.getCode().equals(infosRole.getCode())) {
					infoBean.set("AFFECTATION_ID_ROLE#" + i, currentRole.getIdRole());
					break;
				}
			}
		}
	}

	/**
	 * controle et stockage des affectations de rôles dans la variable ROLE.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ctx
	 *            the ctx
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public static void traiterPRINCIPAL(final InfoBean infoBean, final OMContext ctx) throws Exception {
		final String action = infoBean.getActionUtilisateur();
		if (action.equals(InfoBean.ACTION_VALIDER)) {
			String roles = "";
			for (int i = 0; i < infoBean.getInt("AFFECTATIONS_NB_ITEMS"); i++) {
				roles += "[";
				roles += infoBean.getString("ROLE_AFFECTATION#" + i);
				roles += ";";
				// JSS 20051104 : gestion des périmètres
				String structurePerimetre = "";
				if (StringUtils.isNotBlank(infoBean.getString("STRUCTURE_AFFECTATION#" + i))) {
					structurePerimetre = infoBean.getString("STRUCTURE_AFFECTATION#" + i);
				}
				String rubriquePerimetre = "";
				if (StringUtils.isNotBlank(infoBean.getString("RUBRIQUE_AFFECTATION#" + i))) {
					rubriquePerimetre = infoBean.getString("RUBRIQUE_AFFECTATION#" + i);
				}
				String groupePerimetre = "";
				if (StringUtils.isNotBlank(infoBean.getString("GROUPE_AFFECTATION#" + i))) {
					groupePerimetre = infoBean.getString("GROUPE_AFFECTATION#" + i);
				}
				final Perimetre perimetre = new Perimetre(structurePerimetre, rubriquePerimetre, "", groupePerimetre, "");
				roles += perimetre.getChaineSerialisee();
				roles += "]";
			}
			infoBean.set("ROLES", roles);
		}
		if (action.contains("SUPPRIMER_AFFECTATION")) {
			/* Suppression de l'élément courant */
			final int indiceDiese = action.indexOf("#");
			final int indice = Integer.parseInt(action.substring(indiceDiese + 1));
			for (int j = indice; j < infoBean.getInt("AFFECTATIONS_NB_ITEMS") - 1; j++) {
				infoBean.set("STRUCTURE_AFFECTATION#" + j, infoBean.get("STRUCTURE_AFFECTATION#" + (j + 1)));
				infoBean.set("STRUCTURE_TYPE_AFFECTATION#" + j, infoBean.get("STRUCTURE_TYPE_AFFECTATION#" + (j + 1)));
				infoBean.set("RUBRIQUE_AFFECTATION#" + j, infoBean.get("RUBRIQUE_AFFECTATION#" + (j + 1)));
				infoBean.set("RUBRIQUE_TYPE_AFFECTATION#" + j, infoBean.get("RUBRIQUE_TYPE_AFFECTATION#" + (j + 1)));
				infoBean.set("GROUPE_AFFECTATION#" + j, infoBean.get("GROUPE_AFFECTATION#" + (j + 1)));
				infoBean.set("GROUPE_TYPE_AFFECTATION#" + j, infoBean.get("GROUPE_TYPE_AFFECTATION#" + (j + 1)));
				infoBean.set("ROLE_AFFECTATION#" + j, infoBean.get("ROLE_AFFECTATION#" + (j + 1)));
				infoBean.set("AFFECTATION_INTITULE#" + j, infoBean.get("AFFECTATION_INTITULE#" + (j + 1)));
			}
			infoBean.setInt("AFFECTATIONS_NB_ITEMS", infoBean.getInt("AFFECTATIONS_NB_ITEMS") - 1);
			rafraichirPRINCIPAL(infoBean, ctx);
		}
		if (action.contains("AJOUTER_AFFECTATION")) {
			if ((infoBean.getString("ROLE_AFFECTATION").length() == 0) || (infoBean.getString("ROLE_AFFECTATION").equals("0000"))) {
				throw new ErreurApplicative(MessageHelper.getCoreMessage(ctx.getLocale(),"ROLE.ERREUR.ROLE_OBLIGATOIRE"));
			}
			final int nbItems = infoBean.getInt("AFFECTATIONS_NB_ITEMS");
			String structurePerimetre = "";
			if (StringUtils.isNotBlank(infoBean.getString("STRUCTURE_AFFECTATION"))) {
				structurePerimetre = infoBean.getString("STRUCTURE_AFFECTATION");
			}
			String rubriquePerimetre = "";
			if (StringUtils.isNotBlank(infoBean.getString("RUBRIQUE_AFFECTATION"))) {
				rubriquePerimetre = infoBean.getString("RUBRIQUE_AFFECTATION");
			}
			String groupePerimetre = "";
			if (StringUtils.isNotBlank(infoBean.getString("GROUPE_AFFECTATION"))) {
				groupePerimetre = infoBean.getString("GROUPE_AFFECTATION");
			}
			/* Controle du périmètre */
			final Perimetre perimetreAffectation = new Perimetre(structurePerimetre, rubriquePerimetre, "", groupePerimetre, "");
			final InfosRole infosRole = Role.renvoyerItemRole(infoBean.getString("ROLE_AFFECTATION"));
			final Perimetre perimetreRole = new Perimetre(infosRole.getPerimetre());
			if (! perimetreAffectation.estUnSousPerimetreDe(perimetreRole, true)) {
				throw new ErreurApplicative(MessageHelper.getCoreMessage(ctx.getLocale(),"ROLE.ERREUR.PERIMETRE_AFFECTATION"));
			}
			if (!checkRoleUnicity(infoBean, perimetreAffectation)) {
				throw new ErreurApplicative(MessageHelper.getCoreMessage(ctx.getLocale(),"ROLE.ERREUR.PARAMETRAGE_EXISTANT"));
			}
			infoBean.set("STRUCTURE_AFFECTATION#" + nbItems, infoBean.getString("STRUCTURE_AFFECTATION"));
			infoBean.set("STRUCTURE_TYPE_AFFECTATION#" + nbItems, infoBean.getString("STRUCTURE_TYPE_AFFECTATION"));
			infoBean.set("RUBRIQUE_AFFECTATION#" + nbItems, infoBean.getString("RUBRIQUE_AFFECTATION"));
			infoBean.set("RUBRIQUE_TYPE_AFFECTATION#" + nbItems, infoBean.getString("RUBRIQUE_TYPE_AFFECTATION"));
			infoBean.set("GROUPE_AFFECTATION#" + nbItems, infoBean.getString("GROUPE_AFFECTATION"));
			infoBean.set("GROUPE_TYPE_AFFECTATION#" + nbItems, infoBean.getString("GROUPE_TYPE_AFFECTATION"));
			infoBean.set("ROLE_AFFECTATION#" + nbItems, infoBean.getString("ROLE_AFFECTATION"));
			infoBean.setInt("AFFECTATIONS_NB_ITEMS", nbItems + 1);
			rafraichirPRINCIPAL(infoBean, ctx);
			infoBean.remove("ROLE_AFFECTATION");
		}
	}

	private static boolean checkRoleUnicity(final InfoBean infoBean, final Perimetre addPerimetre) throws Exception {
		for (int i = 0; i < infoBean.getInt("AFFECTATIONS_NB_ITEMS"); i++) {
			final String roleAffectation = String.format("ROLE_AFFECTATION#%d", i);
			if (infoBean.getString(roleAffectation).equals(infoBean.getString("ROLE_AFFECTATION"))) {
				final InfosRole infosRole = Role.renvoyerItemRole(roleAffectation);
				final Perimetre perimetreRole = new Perimetre(infosRole.getPerimetre());
				if (perimetreRole.equals(addPerimetre)) {
					return false;
				}
			}
		}
		return true;
	}
}
