/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 3 déc. 2005
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.univ.objetspartages.processus;

import java.text.DateFormat;
import java.util.Map;
import java.util.Vector;

import com.jsbsoft.jtf.database.OMContext;
import com.kportal.extension.module.plugin.objetspartages.DefaultPluginFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Ressource;
import com.univ.utils.ContexteUtil;

// TODO: Auto-generated Javadoc
/**
 * The Class ControleurFichiergw.
 */
public class ControleurFichiergw extends DefaultPluginFiche {

	/**
	 * Preparer principal.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ficheUniv
	 *            the fiche univ
	 * @param meta
	 *            The metatag
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public void preparerPrincipal(final Map<String, Object> infoBean, final FicheUniv ficheUniv, final Metatag meta) throws Exception {
		if (ficheUniv.getIdFiche().equals(new Long(0))) {
			return;
		}
		// traitement uniquement pour les fiches avec fichier joints
		if (super.isActive(ficheUniv.getClass().getName())) {
			final OMContext ctx = ContexteUtil.getContexteUniv();
			Vector<Ressource> listeFichier = Ressource.getListeFichier(ficheUniv);
			String totalFichierJoint = "";
			String mode = "";
			String libelleFichierJoint = "";
			String codeParent = "";
			String indice = "";
			int nbTotal = 1;
			String nomDonnee = "FICHIER_MULTIPLE";
			int i = 0;
			if (listeFichier.size() > 0) {
				for (i = 0; i < listeFichier.size(); i++) {
					final com.univ.objetspartages.om.Ressource f = listeFichier.get(i);
					codeParent = f.getCodeParent();
					mode = f.getTypeRessource();
					final String indiceCourant = codeParent.substring(codeParent.indexOf("NO=") + 3, codeParent.length());
					if (!indice.equals(indiceCourant)) {
						if (totalFichierJoint.length() > 0) {
							infoBean.put("TOTAL_" + nomDonnee + "_" + indice, totalFichierJoint);
							infoBean.put("MODE_" + nomDonnee + "_" + indice, mode);
							nbTotal++;
						}
						totalFichierJoint = "";
						indice = indiceCourant;
					}
					if (totalFichierJoint.length() > 0) {
						totalFichierJoint += "|";
					}
					libelleFichierJoint = "";
					if (f.getTitre() != null && f.getTitre().length() > 0) {
						libelleFichierJoint = f.getTitre() + " - ";
					}
					libelleFichierJoint += f.getSource();
					totalFichierJoint += f.getIdRessource().toString() + ";" + libelleFichierJoint.replaceAll(";", ",").replaceAll("\\|", " ") + ";" + f.getFormat().replaceAll(
						";", ",") + ";" + f.getLegende().replaceAll(";", ",").replaceAll("\\|", " ") + ";" + DateFormat.getDateInstance(DateFormat.SHORT, ctx.getLocale()).format(f.getDateCreation());
					//+ ";"+ f.getPoids();
				}
				infoBean.put("TOTAL_" + nomDonnee + "_" + indice, totalFichierJoint);
				infoBean.put("MODE_" + nomDonnee + "_" + indice, mode);
				infoBean.put("NB_" + nomDonnee, Integer.toString(nbTotal));
			}
			listeFichier = Ressource.getListeFichierIndice(ficheUniv);
			String fichierUniqueIndice = "";
			nomDonnee = "FICHIER_UNIQUE";
			if (listeFichier.size() > 0) {
				codeParent = "";
				indice = "";
				for (i = 0; i < listeFichier.size(); i++) {
					final com.univ.objetspartages.om.Ressource f = listeFichier.get(i);
					codeParent = f.getCodeParent();
					indice = codeParent.substring(codeParent.indexOf("NO=") + 3, codeParent.length());
					libelleFichierJoint = "";
					if (f.getTitre() != null && f.getTitre().length() > 0) {
						libelleFichierJoint = f.getTitre() + " - ";
					}
					libelleFichierJoint += f.getSource();
					fichierUniqueIndice = f.getIdRessource().toString() + ";" + libelleFichierJoint.replaceAll(";", ",").replaceAll("\\|", " ") + ";" + f.getFormat().replaceAll(
						";", ",") + ";" + f.getLegende().replaceAll(";", ",").replaceAll("\\|", " ") + ";" + DateFormat.getDateInstance(DateFormat.SHORT, ctx.getLocale()).format(
						f.getDateCreation());
					//+ ";"+ f.getPoids();
					infoBean.put(nomDonnee + "_" + indice, fichierUniqueIndice);
					mode = f.getTypeRessource();
					infoBean.put("LIBELLE_" + nomDonnee + "_" + indice, libelleFichierJoint);
					infoBean.put("MODE_" + nomDonnee + "_" + indice, mode);
				}
				infoBean.put("NB_" + nomDonnee, Integer.toString(i));
			}
		}
	}

	/**
	 * Traiter principal.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ficheUniv
	 *            the _fiche univ
	 * @param metatag
	 *            The metatag
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public void traiterPrincipal(final Map<String, Object> infoBean, final FicheUniv ficheUniv, final Metatag metatag) throws Exception {
		final OMContext ctx = ContexteUtil.getContexteUniv();
		// traitement générique sur la gestion des ressources dans les contenus de type toolbox
		Ressource.saveContentRessource(ContexteUtil.getContexteUniv(), infoBean, ficheUniv);
		// traitement uniquement pour les fiches déclarées sur le plugin
		if (super.isActive(ficheUniv.getClass().getName())) {
			String nomDonnee = "FICHIER_MULTIPLE";
			if (infoBean.get("NB_" + nomDonnee) != null) {
				int nombreFichier = 0;
				try {
					nombreFichier = Integer.parseInt((String) infoBean.get("NB_" + nomDonnee));
				} catch (final Exception e) {}
				if (nombreFichier > 0) {
					for (int i = 1; i <= nombreFichier; i++) {
						if (infoBean.get("TOTAL_" + nomDonnee + "_" + i) != null) {
							Ressource.synchroniserListeFichier(ctx, ficheUniv, (String) infoBean.get("TOTAL_" + nomDonnee + "_" + i),
								(String) infoBean.get("MODE_" + nomDonnee + "_" + i), i);
						}
					}
				}
			}
			nomDonnee = "FICHIER_UNIQUE";
			if (infoBean.get("NB_" + nomDonnee) != null) {
				int nombreFichier = 0;
				try {
					nombreFichier = Integer.parseInt((String) infoBean.get("NB_" + nomDonnee));
				} catch (final Exception e) {}
				if (nombreFichier > 0) {
					for (int i = 1; i <= nombreFichier; i++) {
						if (infoBean.get(nomDonnee + "_" + i) != null) {
							Ressource.synchroniserFichier(ctx, ficheUniv, (String) infoBean.get(nomDonnee + "_" + i), (String) infoBean.get("MODE_" + nomDonnee + "_" + i), i);
						}
					}
				}
			}
		}
	}

	@Override
	public void supprimerObjets(final FicheUniv ficheUniv, final Metatag meta, final String classeObjetCible) throws Exception {
		Ressource.supprimerFichiers(ficheUniv);
	}

	@Override
	public boolean isActive(final String classe) {
		// ce plugin est actif pour toutes les fiches car il doit a minima nettoyer les ressources du contenu (toolbox)
		return Boolean.TRUE;
	}
}
