/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.processus;

import java.util.StringTokenizer;

import com.jsbsoft.jtf.core.InfoBean;
import com.univ.utils.RechercheFiche;
// TODO: Auto-generated Javadoc
/**
 * The Class RechercheDistante.
 */
public class RechercheDistante extends RechercheFiche {



	/**
	 * Commentaire relatif au constructeur RechercheGRS.
	 * 
	 * @param ciu
	 *            the ciu
	 */
	public RechercheDistante(InfoBean ciu) {
		super(ciu);
	}

	/* (non-Javadoc)
	 * @see com.univ.utils.RechercheFiche#traiterRECHERCHE()
	 */
	@Override
	protected void traiterRECHERCHE() throws Exception {
		if (action.equals(InfoBean.ACTION_VALIDER)) {
			String requete = "";
			String listeParams = infoBean.getString("LISTE_PARAMS");
			StringTokenizer st = new StringTokenizer(listeParams, ",");
			while (st.hasMoreTokens()) {
				String nomParam = st.nextToken().trim();
				if (infoBean.getString(nomParam).length() > 0) {
					if (requete.length() > 0) {
						requete += "&";
					}
					requete += nomParam + "=" + infoBean.getString(nomParam);
				}
			}
			infoBean.set("REQUETE_DISTANTE", requete);
			preparerLISTE();
		}
	}
}
