/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.processus;

import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Structure;

/**
 * processus saisie Utilisateur.
 */
public class RechercheGroupeDsi extends ProcessusBean {

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(RechercheGroupeDsi.class);

	/** The Constant ECRAN_RECHERCHE. */
	private static final String ECRAN_RECHERCHE = "RECHERCHE";

	/** The Constant ECRAN_LISTE. */
	private static final String ECRAN_LISTE = "LISTE";

	//	JSS 20050510 : groupes dynamiques
	/** The autorisations. */
	AutorisationBean autorisations = null;

	/**
	 * processus recherche utilisateur.
	 *
	 * @param ciu
	 *            com.jsbsoft.jtf.core.InfoBean
	 */
	public RechercheGroupeDsi(final InfoBean ciu) {
		super(ciu);
	}

	/**
	 * Affichage de la liste des utilisateurs.
	 *
	 * @throws Exception
	 *             the exception
	 */
	private void preparerLISTE() throws Exception {
		int i = 0;
		ecranLogique = ECRAN_LISTE;
		groupedsi.select("", infoBean.getString("TYPE"), infoBean.getString("LIBELLE"), infoBean.getString("CODE_STRUCTURE"), "");
		String sPermission = infoBean.getString("PERMISSION");
		if (sPermission == null) {
			sPermission = "";
		}
		while (groupedsi.nextItem()) {
			boolean insererGroupe = true;
			// Test permission
			if (sPermission.length() > 0) {
				if (!autorisations.possedePermissionPartielleSurPerimetre(new PermissionBean(infoBean.getString("PERMISSION")), new Perimetre("", "", "", groupedsi.getCode(), ""))) {
					insererGroupe = false;
				}
			}
			if (insererGroupe) {
				infoBean.set("CODE#" + i, groupedsi.getCode());
				infoBean.set("LIBELLE#" + i, groupedsi.getLibelle());
				infoBean.set("LIBELLE_STRUCTURE#" + i, Structure.getLibelleAffichable(groupedsi.getCodeStructure(), "0"));
				i++;
			}
		}
		if (i > 0) {
			infoBean.set("LISTE_NB_ITEMS", i);
		} else {
			infoBean.addMessageErreur("Aucun groupe ne répond aux critères");
		}
	}

	/**
	 * Affichage de l'écran des critères de recherche d'un utilisateur.
	 *
	 * @throws Exception
	 *             the exception
	 */
	private void preparerRECHERCHE() throws Exception {
		ecranLogique = ECRAN_RECHERCHE;
		infoBean.set("LISTE_TYPES", Libelle.getListe("11", LangueUtil.getDefaultLocale()));
	}

	/**
	 * Point d'entrée du processus.
	 *
	 * @return true, if traiter action
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public boolean traiterAction() throws Exception {
		autorisations = (AutorisationBean) getGp().getSessionUtilisateur().getInfos().get(SessionUtilisateur.AUTORISATIONS);
		if (autorisations == null) {
			infoBean.setEcranRedirection(WebAppUtil.CONNEXION_BO);
			infoBean.setEcranLogique("LOGIN");
		} else {
			try {
				ecranLogique = infoBean.getEcranLogique();
				action = infoBean.getActionUtilisateur();
				groupedsi = new Groupedsi();
				groupedsi.setCtx(this);
				groupedsi.init();
				etat = EN_COURS;
				/* Entrée par lien hyper-texte */
				if (ecranLogique == null) {
					if (action.equals("RECHERCHER")) {
						infoBean.setEtatObjet(InfoBean.ETAT_OBJET_RECHERCHE);
						preparerRECHERCHE();
					}
				} else
				/* Entrée par formulaire */{
					if (ecranLogique.equals(ECRAN_RECHERCHE)) {
						traiterRECHERCHE();
					}
				}
				//placer l'état dans le composant d'infoBean
				infoBean.setEcranLogique(ecranLogique);
			} catch (final Exception e) {
				LOG.error("erreur lors du traitement du processus", e);
				infoBean.addMessageErreur(e.toString());
			}
		}
		// On continue si on n'est pas à la FIN !!!
		return (etat == FIN);
	}

	/**
	 * Traitement associé à l'écran de saisie des critères.
	 *
	 * @throws Exception
	 *             the exception
	 */
	private void traiterRECHERCHE() throws Exception {
		if (action.equals(InfoBean.ACTION_VALIDER)) {
			preparerLISTE();
		}
		if (action.equals(InfoBean.ACTION_ANNULER)) {
			ecranLogique = "FIN_TOOLBOX";
		}
	}

	/** The groupedsi. */
	Groupedsi groupedsi = null;
}
