/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.objetspartages.processus;

import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Profildsi;

// TODO: Auto-generated Javadoc
/**
 * processus saisie Utilisateur.
 */
public class RecherchePublicViseDsi extends ProcessusBean {

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(RecherchePublicViseDsi.class);

	/** The Constant ECRAN_RECHERCHE. */
	private static final String ECRAN_RECHERCHE = "RECHERCHE";

	/**
	 * processus recherche utilisateur.
	 *
	 * @param ciu
	 *            com.jsbsoft.jtf.core.InfoBean
	 */
	public RecherchePublicViseDsi(final InfoBean ciu) {
		super(ciu);
	}

	/**
	 * Affichage de l'écran des critères de recherche d'un utilisateur.
	 *
	 * @throws Exception
	 *             the exception
	 */
	private void preparerRECHERCHE() throws Exception {
		ecranLogique = ECRAN_RECHERCHE;
		infoBean.set("LISTE_PROFILS_DSI", Profildsi.getListeProfilsDSI());
		// JSS 20040419 : Filtrage de l'arbre des groupes
		if (infoBean.get("PERMISSION") != null) {
			final PermissionBean permission = new PermissionBean(infoBean.getString("PERMISSION"));
			// Positionnement variables pour filtre
			infoBean.set("GRS_FILTRE_ARBRE_GROUPE", "1");
			infoBean.set("GRS_PERMISSION_TYPE", permission.getType());
			infoBean.set("GRS_PERMISSION_OBJET", permission.getObjet());
			infoBean.set("GRS_PERMISSION_ACTION", permission.getAction());
		}
	}

	/**
	 * Point d'entrée du processus.
	 *
	 * @return true, if traiter action
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Override
	public boolean traiterAction() throws Exception {
		final Object o = getGp().getSessionUtilisateur().getInfos().get(SessionUtilisateur.AUTORISATIONS);
		if (o == null) {
			infoBean.setEcranRedirection(WebAppUtil.CONNEXION_BO);
			infoBean.setEcranLogique("LOGIN");
		} else {
			try {
				ecranLogique = infoBean.getEcranLogique();
				action = infoBean.getActionUtilisateur();
				etat = EN_COURS;
				/* Entrée par lien hyper-texte */
				if (ecranLogique == null) {
					if (action.equals("RECHERCHER")) {
						infoBean.setEtatObjet(InfoBean.ETAT_OBJET_RECHERCHE);
						preparerRECHERCHE();
					}
				} else
				/* Entrée par formulaire */{
					if (ecranLogique.equals(ECRAN_RECHERCHE)) {
						traiterRECHERCHE();
					}
				}
				//placer l'état dans le composant d'infoBean
				infoBean.setEcranLogique(ecranLogique);
			} catch (final Exception e) {
				LOG.error("erreur de traitement sur le processus", e);
				infoBean.addMessageErreur(e.toString());
			}
		}
		// On continue si on n'est pas à la FIN !!!
		return (etat == FIN);
	}

	/**
	 * Traitement associé à l'écran de saisie des critères.
	 *
	 * @throws Exception
	 *             the exception
	 */
	private void traiterRECHERCHE() throws Exception {
		if (action.equals(InfoBean.ACTION_ANNULER)) {
			ecranLogique = "FIN_TOOLBOX";
		}
	}

	/** The groupedsi. */
	Groupedsi groupedsi = null;
}
